/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.Base64;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;
import scala.Array$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import sun.security.util.HostnameChecker;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u0017\t9B)\u001a4bk2$\bj\\:u]\u0006lWMV3sS\u001aLWM\u001d\u0006\u0003\u0007\u0011\t1a]:m\u0015\t)a!A\u0005tg2\u001cwN\u001c4jO*\u0011q\u0001C\u0001\tif\u0004Xm]1gK*\t\u0011\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+mi\u0011A\u0006\u0006\u0003\u0007]Q!\u0001G\r\u0002\u00079,GOC\u0001\u001b\u0003\u0015Q\u0017M^1y\u0013\tabC\u0001\tI_N$h.Y7f-\u0016\u0014\u0018NZ5fe\"Aa\u0004\u0001B\u0001B\u0003%q$\u0001\u0005nW2{wmZ3s!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0003vi&d\u0017B\u0001\u0013\"\u00055aunZ4fe\u001a\u000b7\r^8ss\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\"\u0001\u000b\u0016\u0011\u0005%\u0002Q\"\u0001\u0002\t\u000by)\u0003\u0019A\u0010\t\u000f1\u0002!\u0019!C\u0005[\u00051An\\4hKJ,\u0012A\f\t\u0003A=J!\u0001M\u0011\u0003\u00199{G)\u001a9t\u0019><w-\u001a:\t\rI\u0002\u0001\u0015!\u0003/\u0003\u001dawnZ4fe\u0002BQ\u0001\u000e\u0001\u0005\u0002U\nq\u0002[8ti:\fW.Z\"iK\u000e\\WM]\u000b\u0002mA\u0011q'P\u0007\u0002q)\u0011!%\u000f\u0006\u0003um\n\u0001b]3dkJLG/\u001f\u0006\u0002y\u0005\u00191/\u001e8\n\u0005yB$a\u0004%pgRt\u0017-\\3DQ\u0016\u001c7.\u001a:\t\u000b\u0001\u0003A\u0011A!\u0002\u001b5\fGo\u00195LKJ\u0014WM]8t)\r\u0011\u0005*\u0015\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\b\u0005>|G.Z1o\u0011\u0015Iu\b1\u0001K\u0003!Awn\u001d;oC6,\u0007CA&O\u001d\t\u0019E*\u0003\u0002N\t\u00061\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\tiE\tC\u0003S\u007f\u0001\u00071+A\u0005qe&t7-\u001b9bYB\u0011AKV\u0007\u0002+*\u0011!\bE\u0005\u0003/V\u0013\u0011\u0002\u0015:j]\u000eL\u0007/\u00197\t\u000be\u0003A\u0011\u0001.\u0002\u0015%\u001c8*\u001a:cKJ|7\u000f\u0006\u0002C7\")!\u000b\u0017a\u0001'\")Q\f\u0001C\u0001=\u00061a/\u001a:jMf$2AQ0a\u0011\u0015IE\f1\u0001K\u0011\u0015\tG\f1\u0001c\u0003\u001d\u0019Xm]:j_:\u0004\"!F2\n\u0005\u00114\"AC*T\u0019N+7o]5p]\")a\r\u0001C\u0001O\u0006\tR.\u0019;dQ\u000e+'\u000f^5gS\u000e\fG/Z:\u0015\u0007\tC\u0017\u000eC\u0003JK\u0002\u0007!\nC\u0003kK\u0002\u00071.\u0001\tqK\u0016\u00148)\u001a:uS\u001aL7-\u0019;fgB\u00191\t\u001c8\n\u00055$%!B!se\u0006L\bCA8s\u001b\u0005\u0001(BA9V\u0003\u0011\u0019WM\u001d;\n\u0005M\u0004(aC\"feRLg-[2bi\u0016\u0004")
public class DefaultHostnameVerifier
implements HostnameVerifier {
    private final NoDepsLogger logger;

    private NoDepsLogger logger() {
        return this.logger;
    }

    public HostnameChecker hostnameChecker() {
        return HostnameChecker.getInstance((byte)1);
    }

    public boolean matchKerberos(String hostname, Principal principal) {
        return HostnameChecker.match((String)hostname, (Principal)((KerberosPrincipal)principal));
    }

    public boolean isKerberos(Principal principal) {
        return principal != null && principal instanceof KerberosPrincipal;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        boolean bl;
        Base64 base64 = Base64.rfc2045();
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: hostname = ", ", sessionId (base64) = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostname, base64.encodeToString(session.getId(), false)})));
        try {
            Certificate[] peerCertificates = session.getPeerCertificates();
            bl = this.matchCertificates(hostname, peerCertificates);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            try {
                Principal principal = session.getPeerPrincipal();
                if (this.isKerberos(principal)) {
                    bl = this.matchKerberos(hostname, principal);
                } else {
                    this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: Can't verify principal, not Kerberos"})).s((Seq)Nil$.MODULE$));
                    bl = false;
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException2) {
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't verify principal, no principal. Cause: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sSLPeerUnverifiedException2})));
                bl = false;
            }
        }
        boolean result = bl;
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: returning ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)})));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matchCertificates(String hostname, Certificate[] peerCertificates) {
        Certificate cert;
        HostnameChecker checker = this.hostnameChecker();
        Certificate[] certificateArray = peerCertificates;
        Option option = Array$.MODULE$.unapplySeq((Object)certificateArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) >= 0 && (cert = (Certificate)((SeqLike)option.get()).apply(0)) instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)cert;
            try {
                checker.match(hostname, x509Certificate);
                return true;
            }
            catch (CertificateException certificateException) {
                Collection<List<?>> subjectAltNames = x509Certificate.getSubjectAlternativeNames();
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: Certificate does not match hostname! subjectAltNames = ", ", hostName = ", " Cause: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subjectAltNames, hostname, certificateException})));
                return false;
            }
        }
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verify: Peer does not have any certificates: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{certificateArray})));
        return false;
    }

    public DefaultHostnameVerifier(LoggerFactory mkLogger) {
        this.logger = mkLogger.apply(this.getClass());
    }
}

