/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.FakeKeyStore$;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import javax.net.ssl.KeyManagerFactory;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.util.Properties$;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0001-\u0011ABR1lK.+\u0017p\u0015;pe\u0016T!a\u0001\u0003\u0002\u0007M\u001cHN\u0003\u0002\u0006\r\u0005I1o\u001d7d_:4\u0017n\u001a\u0006\u0003\u000f!\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011M\u0001!\u0011!Q\u0001\nQ\t\u0001\"\\6M_\u001e<WM\u001d\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\tA!\u001e;jY&\u0011\u0011D\u0006\u0002\u000e\u0019><w-\u001a:GC\u000e$xN]=\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\tir\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0003\u00145\u0001\u0007A\u0003C\u0004\"\u0001\t\u0007I\u0011\u0002\u0012\u0002\r1|wmZ3s+\u0005\u0019\u0003CA\u000b%\u0013\t)cC\u0001\u0007O_\u0012+\u0007o\u001d'pO\u001e,'\u000f\u0003\u0004(\u0001\u0001\u0006IaI\u0001\bY><w-\u001a:!\u0011\u001dI\u0003A1A\u0005\u0002)\n\u0011cR3oKJ\fG/\u001a3LKf\u001cFo\u001c:f+\u0005Y\u0003C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0011a\u0017M\\4\u000b\u0003A\nAA[1wC&\u0011!'\f\u0002\u0007'R\u0014\u0018N\\4\t\rQ\u0002\u0001\u0015!\u0003,\u0003I9UM\\3sCR,GmS3z'R|'/\u001a\u0011\t\u000fY\u0002!\u0019!C\u0001U\u00051AI\u001c(b[\u0016Da\u0001\u000f\u0001!\u0002\u0013Y\u0013a\u0002#o\u001d\u0006lW\r\t\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0003U\u0019\u0016n\u001a8biV\u0014X-\u00117h_JLG\u000f[7P\u0013\u0012+\u0012\u0001\u0010\t\u0003{\rk\u0011A\u0010\u0006\u0003/}R!\u0001Q!\u0002\u0011M,7-\u001e:jifT\u0011AQ\u0001\u0004gVt\u0017B\u0001#?\u0005Ay%M[3di&#WM\u001c;jM&,'\u000f\u0003\u0004G\u0001\u0001\u0006I\u0001P\u0001\u0017'&<g.\u0019;ve\u0016\fEnZ8sSRDWnT%EA!9\u0001\n\u0001b\u0001\n\u0003Q\u0013AF*jO:\fG/\u001e:f\u00032<wN]5uQ6t\u0015-\\3\t\r)\u0003\u0001\u0015!\u0003,\u0003]\u0019\u0016n\u001a8biV\u0014X-\u00117h_JLG\u000f[7OC6,\u0007\u0005C\u0003M\u0001\u0011\u0005Q*\u0001\btQ>,H\u000eZ$f]\u0016\u0014\u0018\r^3\u0015\u00059\u000b\u0006CA\u0007P\u0013\t\u0001fBA\u0004C_>dW-\u00198\t\u000bI[\u0005\u0019A*\u0002\u0019-,\u0017p\u0015;pe\u00164\u0015\u000e\\3\u0011\u0005Q;V\"A+\u000b\u0005Y{\u0013AA5p\u0013\tAVK\u0001\u0003GS2,\u0007\"\u0002.\u0001\t\u0003Y\u0016!E6fs6\u000bg.Y4fe\u001a\u000b7\r^8ssR\u0011A,\u001a\t\u0003;\u000el\u0011A\u0018\u0006\u0003\u0007}S!\u0001Y1\u0002\u00079,GOC\u0001c\u0003\u0015Q\u0017M^1y\u0013\t!gLA\tLKfl\u0015M\\1hKJ4\u0015m\u0019;pefDQAZ-A\u0002M\u000bq!\u00199q!\u0006$\b\u000eC\u0003i\u0001\u0011\u0005\u0011.A\u000ede\u0016\fG/Z*fY\u001a\u001c\u0016n\u001a8fI\u000e+'\u000f^5gS\u000e\fG/\u001a\u000b\u0003UF\u0004\"a[8\u000e\u00031T!!\u001c8\u0002\t\r,'\u000f\u001e\u0006\u0003\u0001>J!\u0001\u001d7\u0003\u001fa+\u0004'O\"feRLg-[2bi\u0016DQA]4A\u0002M\fqa[3z!\u0006L'\u000f\u0005\u0002uk6\ta.\u0003\u0002w]\n91*Z=QC&\u0014\b\"\u0002=\u0001\t\u0003I\u0018\u0001D2m_N,\u0017+^5fi2LHC\u0001>~!\ti10\u0003\u0002}\u001d\t!QK\\5u\u0011\u0015qx\u000f1\u0001\u0000\u0003%\u0019Gn\\:fC\ndW\rE\u0002U\u0003\u0003I1!a\u0001V\u0005%\u0019En\\:fC\ndW\r")
public class FakeKeyStore {
    private final NoDepsLogger logger;
    private final String GeneratedKeyStore;
    private final String DnName;
    private final ObjectIdentifier SignatureAlgorithmOID;
    private final String SignatureAlgorithmName;

    private NoDepsLogger logger() {
        return this.logger;
    }

    public String GeneratedKeyStore() {
        return this.GeneratedKeyStore;
    }

    public String DnName() {
        return this.DnName;
    }

    public ObjectIdentifier SignatureAlgorithmOID() {
        return this.SignatureAlgorithmOID;
    }

    public String SignatureAlgorithmName() {
        return this.SignatureAlgorithmName;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldGenerate(File keyStoreFile) {
        boolean bl;
        Object object = new Object();
        try {
            if (!keyStoreFile.exists()) return true;
            KeyStore store = KeyStore.getInstance("JKS");
            FileInputStream in = new FileInputStream(keyStoreFile);
            try {
                store.load(in, "".toCharArray());
                this.closeQuietly(in);
            }
            catch (Throwable throwable) {
                void var5_4;
                this.closeQuietly((Closeable)var5_4);
                throw throwable;
            }
            ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(store.aliases()).asScala()).foreach((Function1)new Serializable(this, store, object){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FakeKeyStore $outer;
                private final KeyStore store$1;
                public final Object nonLocalReturnKey1$1;

                public final Option<BoxedUnit> apply(String alias) {
                    return Option$.MODULE$.apply((Object)this.store$1.getCertificate(alias)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$shouldGenerate$1 $outer;

                        public final void apply(Certificate c) {
                            RSAPublicKey key = (RSAPublicKey)c.getPublicKey();
                            if (key.getModulus().bitLength() >= 2048) {
                                String string = key.getAlgorithm();
                                String string2 = this.$outer.com$typesafe$sslconfig$ssl$FakeKeyStore$$anonfun$$$outer().SignatureAlgorithmName();
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    return;
                                }
                            }
                            throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, true);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ FakeKeyStore com$typesafe$sslconfig$ssl$FakeKeyStore$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.store$1 = store$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            return false;
        }
        catch (NonLocalReturnControl nonLocalReturnControl22) {
            if (nonLocalReturnControl22.key() != object) throw nonLocalReturnControl22;
            bl = nonLocalReturnControl22.value$mcZ$sp();
        }
        return bl;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public KeyManagerFactory keyManagerFactory(File appPath) {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        File keyStoreFile = new File(appPath, this.GeneratedKeyStore());
        if (this.shouldGenerate(keyStoreFile)) {
            this.logger().info(new StringBuilder().append((Object)"Generating HTTPS key pair in ").append((Object)keyStoreFile.getAbsolutePath()).append((Object)" - this may take some time. If nothing happens, try moving the mouse/typing on the keyboard to generate some entropy.").toString());
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            X509Certificate cert = this.createSelfSignedCertificate(keyPair);
            keyStore.load(null, "".toCharArray());
            keyStore.setKeyEntry("playgenerated", keyPair.getPrivate(), "".toCharArray(), (Certificate[])((Object[])new Certificate[]{cert}));
            keyStore.setCertificateEntry("playgeneratedtrusted", cert);
            FileOutputStream out = new FileOutputStream(keyStoreFile);
            keyStore.store(out, "".toCharArray());
            this.closeQuietly(out);
        }
        FileInputStream in = new FileInputStream(keyStoreFile);
        try {
            keyStore.load(in, "".toCharArray());
            this.closeQuietly(in);
        }
        catch (Throwable throwable) {
            void var9_8;
            this.closeQuietly((Closeable)var9_8);
            throw throwable;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, "".toCharArray());
        return kmf;
        catch (Throwable throwable) {
            void var7_7;
            this.closeQuietly((Closeable)var7_7);
            throw throwable;
        }
    }

    public X509Certificate createSelfSignedCertificate(KeyPair keyPair) {
        X509CertInfo certInfo = new X509CertInfo();
        certInfo.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, new SecureRandom())));
        certInfo.set("version", new CertificateVersion(2));
        Date validFrom = new Date();
        Date validTo = new Date(validFrom.getTime() + 1576800000000L);
        CertificateValidity validity = new CertificateValidity(validFrom, validTo);
        certInfo.set("validity", validity);
        X500Name owner = new X500Name(this.DnName());
        boolean justName = Properties$.MODULE$.isJavaAtLeast("1.8");
        certInfo.set("subject", justName ? owner : new CertificateSubjectName(owner));
        certInfo.set("issuer", justName ? owner : new CertificateIssuerName(owner));
        certInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
        AlgorithmId algorithm2 = new AlgorithmId(this.SignatureAlgorithmOID());
        certInfo.set("algorithmID", new CertificateAlgorithmId(algorithm2));
        X509CertImpl cert = new X509CertImpl(certInfo);
        cert.sign(keyPair.getPrivate(), this.SignatureAlgorithmName());
        AlgorithmId actualAlgorithm = (AlgorithmId)cert.get("x509.algorithm");
        certInfo.set("algorithmID.algorithm", actualAlgorithm);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(keyPair.getPrivate(), this.SignatureAlgorithmName());
        return newCert;
    }

    public void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error closing stream. Cause: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException})));
        }
    }

    public FakeKeyStore(LoggerFactory mkLogger) {
        this.logger = mkLogger.apply(this.getClass());
        this.GeneratedKeyStore = "conf/generated.keystore";
        this.DnName = "CN=localhost, OU=Unit Testing, O=Mavericks, L=Moon Base 1, ST=Cyberspace, C=CY";
        this.SignatureAlgorithmOID = AlgorithmId.sha256WithRSAEncryption_oid;
        this.SignatureAlgorithmName = "SHA256withRSA";
    }
}

