/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.coding;

import akka.http.scaladsl.coding.DeflateCompressor;
import akka.http.scaladsl.coding.GzipDecompressor$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u0017\tqqI_5q\u0007>l\u0007O]3tg>\u0014(BA\u0002\u0005\u0003\u0019\u0019w\u000eZ5oO*\u0011QAB\u0001\tg\u000e\fG.\u00193tY*\u0011q\u0001C\u0001\u0005QR$\bOC\u0001\n\u0003\u0011\t7n[1\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u0011\u0011\u0003R3gY\u0006$XmQ8naJ,7o]8s\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u000e\u0001!AQ\u0003\u0001EC\u0002\u0013Ec#\u0001\u0005eK\u001ad\u0017\r^3s+\u00059\u0002C\u0001\r \u001b\u0005I\"B\u0001\u000e\u001c\u0003\rQ\u0018\u000e\u001d\u0006\u00039u\tA!\u001e;jY*\ta$\u0001\u0003kCZ\f\u0017B\u0001\u0011\u001a\u0005!!UM\u001a7bi\u0016\u0014\b\u0002\u0003\u0012\u0001\u0011\u0003\u0005\u000b\u0015B\f\u0002\u0013\u0011,g\r\\1uKJ\u0004\u0003b\u0002\u0013\u0001\u0005\u0004%I!J\u0001\tG\",7m[*v[V\ta\u0005\u0005\u0002\u0019O%\u0011\u0001&\u0007\u0002\u0006\u0007J\u001b5G\r\u0005\u0007U\u0001\u0001\u000b\u0011\u0002\u0014\u0002\u0013\rDWmY6Tk6\u0004\u0003b\u0002\u0017\u0001\u0001\u0004%I!L\u0001\u000bQ\u0016\fG-\u001a:TK:$X#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\u000f\t{w\u000e\\3b]\"9Q\u0007\u0001a\u0001\n\u00131\u0014A\u00045fC\u0012,'oU3oi~#S-\u001d\u000b\u0003oi\u0002\"a\f\u001d\n\u0005e\u0002$\u0001B+oSRDqa\u000f\u001b\u0002\u0002\u0003\u0007a&A\u0002yIEBa!\u0010\u0001!B\u0013q\u0013a\u00035fC\u0012,'oU3oi\u0002Bqa\u0010\u0001A\u0002\u0013%\u0001)A\u0005csR,7OU3bIV\t\u0011\t\u0005\u00020\u0005&\u00111\t\r\u0002\u0005\u0019>tw\rC\u0004F\u0001\u0001\u0007I\u0011\u0002$\u0002\u001b\tLH/Z:SK\u0006$w\fJ3r)\t9t\tC\u0004<\t\u0006\u0005\t\u0019A!\t\r%\u0003\u0001\u0015)\u0003B\u0003)\u0011\u0017\u0010^3t%\u0016\fG\r\t\u0005\u0006\u0017\u0002!\t\u0006T\u0001\u0013G>l\u0007O]3tg^KG\u000f\u001b\"vM\u001a,'\u000fF\u0002N%R\u0003\"A\u0014)\u000e\u0003=S!\u0001\b\u0005\n\u0005E{%A\u0003\"zi\u0016\u001cFO]5oO\")1K\u0013a\u0001\u001b\u0006)\u0011N\u001c9vi\")QK\u0013a\u0001-\u00061!-\u001e4gKJ\u00042aL,Z\u0013\tA\u0006GA\u0003BeJ\f\u0017\u0010\u0005\u000205&\u00111\f\r\u0002\u0005\u0005f$X\rC\u0003^\u0001\u0011Ec,A\bgYV\u001c\bnV5uQ\n+hMZ3s)\tiu\fC\u0003V9\u0002\u0007a\u000bC\u0003b\u0001\u0011E#-\u0001\tgS:L7\u000f[,ji\"\u0014UO\u001a4feR\u0011Qj\u0019\u0005\u0006+\u0002\u0004\rA\u0016\u0005\u0006K\u0002!IAZ\u0001\nkB$\u0017\r^3De\u000e$\"aN4\t\u000bM#\u0007\u0019A'\t\u000b%\u0004A\u0011\u00026\u0002\r!,\u0017\rZ3s)\u0005i\u0005\"\u00027\u0001\t\u0013Q\u0017a\u0002;sC&dWM\u001d")
public class GzipCompressor
extends DeflateCompressor {
    private Deflater deflater;
    private final CRC32 checkSum = new CRC32();
    private boolean headerSent = false;
    private long bytesRead = 0L;
    private volatile boolean bitmap$0;

    private Deflater deflater$lzycompute() {
        GzipCompressor gzipCompressor = this;
        synchronized (gzipCompressor) {
            if (!this.bitmap$0) {
                this.deflater = new Deflater(9, true);
                this.bitmap$0 = true;
            }
            return this.deflater;
        }
    }

    @Override
    public Deflater deflater() {
        return this.bitmap$0 ? this.deflater : this.deflater$lzycompute();
    }

    private CRC32 checkSum() {
        return this.checkSum;
    }

    private boolean headerSent() {
        return this.headerSent;
    }

    private void headerSent_$eq(boolean x$1) {
        this.headerSent = x$1;
    }

    private long bytesRead() {
        return this.bytesRead;
    }

    private void bytesRead_$eq(long x$1) {
        this.bytesRead = x$1;
    }

    @Override
    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        this.updateCrc(input);
        return this.header().$plus$plus(super.compressWithBuffer(input, buffer));
    }

    @Override
    public ByteString flushWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.flushWithBuffer(buffer));
    }

    @Override
    public ByteString finishWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.finishWithBuffer(buffer)).$plus$plus(this.trailer());
    }

    private void updateCrc(ByteString input) {
        this.checkSum().update((byte[])input.toArray(ClassTag$.MODULE$.Byte()));
        this.bytesRead_$eq(this.bytesRead() + (long)input.length());
    }

    private ByteString header() {
        ByteString byteString;
        if (this.headerSent()) {
            byteString = ByteString$.MODULE$.empty();
        } else {
            this.headerSent_$eq(true);
            byteString = GzipDecompressor$.MODULE$.Header();
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    private ByteString trailer() {
        void var3_3;
        int crc = (int)this.checkSum().getValue();
        int tot = (int)this.bytesRead();
        ByteString trailer = this.int32$1(crc).$plus$plus(this.int32$1(tot));
        return var3_3;
    }

    private final ByteString int32$1(int i) {
        return ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{i, i >> 8, i >> 16, i >> 24}), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }
}

