/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.ordering.ConfigurationItemIdComparator;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DeployitRepositoryResource
extends RepositoryResource {
    @Autowired
    private ConfigurationItemIdComparator comparator;

    protected void checkDeletePermission(String id) {
        if (DeployitPermissions.IMPORT_REMOVE.isApplicableTo(id)) {
            this.checkPermission(DeployitPermissions.IMPORT_REMOVE, id);
        } else {
            this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        }
    }

    public List<ConfigurationItemId> query(Type type, String parent, String ancestor, String namePattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage) {
        List result = super.query(type, parent, ancestor, namePattern, lastModifiedBefore, lastModifiedAfter, page, resultPerPage);
        if (this.isNoPagination(resultPerPage)) {
            this.sort(result);
        }
        return result;
    }

    private void sort(List<ConfigurationItemId> result) {
        Collections.sort(result, this.comparator);
    }

    private boolean isNoPagination(long resultPerPage) {
        return resultPerPage <= 0L;
    }
}

