/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.InternalReportProxy;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.TaskWithStepsView;
import com.xebialabs.deployit.core.rest.api.reports.AggregatedDeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.ControlTasksReport;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsForEnvironmentReport;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsKeyIndicator;
import com.xebialabs.deployit.core.rest.api.reports.DeploymentsStateBreakdownReport;
import com.xebialabs.deployit.core.rest.api.reports.ProvisioningReport;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskReport;
import com.xebialabs.deployit.core.rest.api.reports.widgets.WidgetRegistry;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ReportResource
extends AbstractSecuredResource
implements InternalReportProxy {
    @Autowired
    private JcrTaskArchive taskArchive;
    @Autowired
    private DownloadResource downloadResource;
    @Autowired
    private RepositoryService repositoryService;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");

    public Report deploymentsForEnvironment(String environment, Date date) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)environment, (String)"environment");
        Checks.checkNotNull((Object)date, (String)"date");
        Checks.checkNotNull((Object)date.getCalendar(), (String)"date");
        DeploymentsForEnvironmentReport report = new DeploymentsForEnvironmentReport(this.taskArchive);
        report.getSearchParameters().forEnvironment(environment).createdOnOrBefore(date.asDateTime());
        return report.report();
    }

    @Workdir(prefix="download")
    public String downloadDeploymentsForEnvironment(String environment, Date date) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.deploymentsForEnvironment(environment, date);
            String fileName = String.format("deployments-%s-%s.csv", environment.replaceAll("/", "_"), DATE_FORMAT.print((ReadableInstant)date.asDateTime()));
            return this.createDownloadToken(report, fileName);
        });
    }

    @Deprecated
    public TaskWithSteps getTask(String taskId) {
        return new TaskWithStepsView((SerializableTask)this.retrieveTask(taskId, true));
    }

    public TaskWithBlock getTaskWithBlock(String taskId) {
        return this.retrieveTask(taskId, false);
    }

    private TaskWithBlock retrieveTask(String taskId, boolean loadSteps) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        ArchivedTask t = this.taskArchive.getTask(taskId, loadSteps);
        this.checkAccessTo(t.getMetadata());
        return t;
    }

    public StepBlockState getStepBlock(String taskId, String blockId) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        this.checkAccessTo(this.taskArchive.getTaskMetadata(taskId));
        BlockState block = this.taskArchive.getBlock(taskId, blockId);
        if (block instanceof StepBlockState) {
            return (StepBlockState)block;
        }
        throw new DeployitException("Block [%s] from task [%s] is a composite block so it has no steps", new Object[]{blockId, taskId});
    }

    private void checkAccessTo(Map<String, String> taskMetadata) {
        boolean isCloudTask;
        boolean isControlTask = TaskType.CONTROL.name().equals(taskMetadata.get("taskType"));
        boolean bl = isCloudTask = taskMetadata.get("cloudOperation") != null;
        if (isCloudTask) {
            this.doCloudTaskPermissionCheck(taskMetadata);
        } else if (isControlTask) {
            this.doControlTaskPermissionCheck(taskMetadata);
        } else {
            this.doDeploymentTaskPermissionCheck(taskMetadata);
        }
    }

    private void doDeploymentTaskPermissionCheck(Map<String, String> taskMetadata) {
        String envId = taskMetadata.get("environment_id");
        String appName = taskMetadata.get("application");
        List applications = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(appName));
        if (applications.size() != 1) {
            throw new DeployitException("Unable to locate application for report");
        }
        String appId = ((ConfigurationItemData)applications.get(0)).getId();
        if (!this.hasPermission(PlatformPermissions.READ, envId) || !this.hasPermission(PlatformPermissions.READ, appId)) {
            throw PermissionDeniedException.withMessage((String)"You need read permissions for both the environment and application to view the archived task.");
        }
    }

    private void doControlTaskPermissionCheck(Map<String, String> taskMetadata) {
        String ciID = taskMetadata.get("controlTaskTargetCI");
        if (Strings.isNullOrEmpty((String)ciID) && !PermissionHelper.isCurrentUserAdmin()) {
            throw PermissionDeniedException.withMessage((String)"Control tasks that don't have their target CI archived can only be viewed by admin.");
        }
        if (!this.hasPermission(DeployitPermissions.CONTROLTASK_EXECUTE, ciID)) {
            throw PermissionDeniedException.withMessage((String)"You need controltask#execute permission on an archived control task's target CI to view it.");
        }
    }

    private void doCloudTaskPermissionCheck(Map<String, String> taskMetadata) {
        String cloudEnvId = taskMetadata.get("cloudEnvironmentId");
        String cloudTemplId = taskMetadata.get("cloudEnvironmentTemplateId");
        if (!this.hasPermission(PlatformPermissions.READ, cloudEnvId) || !this.hasPermission(PlatformPermissions.READ, cloudTemplId)) {
            throw PermissionDeniedException.withMessage((String)"You need read permissions for both the environment and the environment template to view the archived cloud task.");
        }
    }

    public Report getTaskReport(Date begin, Date end, String filterType, List<ConfigurationItemId> configurationItemIds) {
        FilterType filter;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        TaskReport report = new TaskReport(this.taskArchive);
        report.getSearchParameters().createdBetween(begin.asDateTime(), end.asDateTime());
        if (filterType != null && (filter = FilterType.valueOf((String)filterType.toUpperCase())) != FilterType.NONE) {
            report.getSearchParameters().forFilterType(filter, configurationItemIds);
        }
        return report.report();
    }

    @Workdir(prefix="download")
    public String downloadTaskReport(Date begin, Date end, String filterType, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.getTaskReport(begin, end, filterType, configurationItemIds);
            String fileName = String.format("tasks-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
            return this.createDownloadToken(report, fileName);
        });
    }

    public Report getCloudTasksReport(Date begin, Date end, String filterType, List<ConfigurationItemId> configurationItemIds) {
        FilterType filter;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        ProvisioningReport report = new ProvisioningReport(this.taskArchive);
        report.getSearchParameters().createdBetween(begin.asDateTime(), end.asDateTime());
        FilterType filterType2 = filter = filterType == null ? FilterType.NONE : FilterType.valueOf((String)filterType.toUpperCase());
        if (filter == FilterType.NONE) {
            report.getSearchParameters().forAllCloudEnvironmentTemplates();
        } else {
            report.getSearchParameters().forFilterType(filter, configurationItemIds);
        }
        return report.report();
    }

    @Workdir(prefix="download")
    public String downloadCloudTasksReport(Date begin, Date end, String filterType, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.getCloudTasksReport(begin, end, filterType, configurationItemIds);
            String fileName = String.format("tasks-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
            return this.createDownloadToken(report, fileName);
        });
    }

    public List<ConfigurationItemId> listCloudEnvironmentTemplates() {
        List templateList = this.taskArchive.getCloudEnvironmentTemplates();
        return Lists.newArrayList((Iterable)Lists.transform((List)templateList, ReportResource.toConfigurationItemId("cloud.EnvironmentTemplate")));
    }

    public Report deploymentsStateBreakdown(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        Checks.checkNotNull((Object)filterType, (String)"filterType");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkNotNull(configurationItemIds, (String)"configurationItemIds");
        DeploymentsStateBreakdownReport report = new DeploymentsStateBreakdownReport(this.taskArchive);
        report.getSearchParameters().createdBetween(begin.asDateTime(), end.asDateTime());
        FilterType reportFilterType = FilterType.valueOf((String)filterType.toUpperCase());
        return report.report(reportFilterType, configurationItemIds);
    }

    @Workdir(prefix="download")
    public String downloadDeploymentsStateBreakdown(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.deploymentsStateBreakdown(filterType, begin, end, configurationItemIds);
            String fileName = String.format("deployments-by-state-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
            return this.createDownloadToken(report, fileName);
        });
    }

    public Report deploymentsKeyIndicator(Date begin, Date end, String filterType, List<ConfigurationItemId> configurationItemIds) {
        FilterType filter;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        DeploymentsKeyIndicator report = new DeploymentsKeyIndicator(this.taskArchive);
        report.getSearchParameters().createdBetween(begin.asDateTime(), end.asDateTime());
        if (filterType != null && (filter = FilterType.valueOf((String)filterType.toUpperCase())) != FilterType.NONE) {
            report.getSearchParameters().forFilterType(filter, configurationItemIds);
        }
        return report.report();
    }

    public Report getControlTasksReport(Date begin, Date end) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkTrue((begin == null || begin.getCalendar() != null ? 1 : 0) != 0, (String)"If begin date is specified, its calendar must be filled", (Object[])new Object[0]);
        Checks.checkTrue((end == null || end.getCalendar() != null ? 1 : 0) != 0, (String)"If end date is specified, its calendar must be filled", (Object[])new Object[0]);
        DateTime startDate = begin == null ? null : begin.asDateTime();
        DateTime endDate = end == null ? null : end.asDateTime();
        return new ControlTasksReport(this.taskArchive, startDate, endDate, DeployitPermissions.CONTROLTASK_EXECUTE.getPermissionHandler()).createReport();
    }

    @Workdir(prefix="download")
    public String downloadControlTasksReport(Date begin, Date end) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.getControlTasksReport(begin, end);
            DateTime beginDT = begin != null ? begin.asDateTime() : new DateTime(1, 1, 1, 0, 0, 0);
            DateTime endDT = end != null ? end.asDateTime() : new DateTime();
            String fileName = String.format("tasks-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)beginDT), DATE_FORMAT.print((ReadableInstant)endDT));
            return this.createDownloadToken(report, fileName);
        });
    }

    public Report deploymentsKeyIndicatorAggregatedByFilterType(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)filterType, (String)"filterType");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Checks.checkNotNull(configurationItemIds, (String)"configurationItemIds");
        FilterType reportFilterType = FilterType.valueOf((String)filterType.toUpperCase());
        AggregatedDeploymentsKeyIndicator report = new AggregatedDeploymentsKeyIndicator(this.taskArchive);
        report.getSearchParameters().createdBetween(new DateTime((Object)begin.getCalendar()), new DateTime((Object)end.getCalendar()));
        return report.report(reportFilterType, configurationItemIds);
    }

    @Workdir(prefix="download")
    public String downloadDeploymentsKeyIndicator(String filterType, Date begin, Date end, List<ConfigurationItemId> cis) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.deploymentsKeyIndicator(begin, end, filterType, cis);
            String fileName = String.format("deployments-key-indicator-%s-%s.csv", DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
            return this.createDownloadToken(report, fileName);
        });
    }

    @Workdir(prefix="download")
    public String downloadDeploymentsKeyIndicatorAggregatedByFilterType(String filterType, Date begin, Date end, List<ConfigurationItemId> configurationItemIds) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        return (String)WorkDirTemplate.cleanOnException(workDir -> {
            Report report = this.deploymentsKeyIndicatorAggregatedByFilterType(filterType, begin, end, configurationItemIds);
            String fileName = String.format("aggregated-deployments-key-indicator-%s-%s-%s.csv", filterType, DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
            return this.createDownloadToken(report, fileName);
        });
    }

    public Report getDashboardWidgetReport(String widget, Date begin, Date end) {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Checks.checkNotNull((Object)widget, (String)"widget");
        Checks.checkNotNull((Object)begin, (String)"begin");
        Checks.checkNotNull((Object)begin.getCalendar(), (String)"begin");
        Checks.checkNotNull((Object)end, (String)"end");
        Checks.checkNotNull((Object)end.getCalendar(), (String)"end");
        Preconditions.checkArgument((begin.getCalendar().getTime().compareTo(end.getCalendar().getTime()) <= 0 ? 1 : 0) != 0);
        return WidgetRegistry.valueOf(WidgetRegistry.class, widget.toUpperCase()).getWidget(this.taskArchive).getReport(begin.asDateTime(), end.asDateTime());
    }

    public List<ConfigurationItemId> listEnvironments() {
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        List environments = this.taskArchive.getAllEnvironments();
        Collections.sort(environments);
        return Lists.newArrayList((Iterable)Lists.transform((List)environments, ReportResource.toConfigurationItemId("udm.Environment")));
    }

    private static Function<String, ConfigurationItemId> toConfigurationItemId(String type) {
        return input -> new ConfigurationItemId(input, Type.valueOf((String)type));
    }

    private String createDownloadToken(Report report, String fileName) {
        try {
            File to = new File(WorkdirHolder.get().getPath(), fileName);
            Files.write((CharSequence)ReportUtils.toCsv(report), (File)to, (Charset)Charset.defaultCharset());
            return this.downloadResource.register(to, WorkdirHolder.get(), "text/csv");
        }
        catch (Exception re) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Oops!", (Throwable)re);
            WorkdirHolder.get().delete();
            throw new IllegalStateException(re);
        }
    }

    public void setTaskArchive(JcrTaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

