/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.scheduler;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.tasker.BlockBuilders$;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.xlplatform.scheduler.ControlTaskHolder;
import com.xebialabs.xlplatform.scheduler.ControlTaskService;
import java.util.List;
import java.util.Map;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;

public abstract class ControlTaskService$class {
    public static ControlTaskHolder prepareControlTask(ControlTaskService $this, String configurationItemId, String controlTaskName, Map controlTaskParams) {
        Parameters parameters;
        ConfigurationItem ci = $this.repositoryService().read(configurationItemId);
        MethodDescriptor methodDescriptor = ci.getType().getDescriptor().getControlTask(controlTaskName);
        Checks.checkArgument((methodDescriptor != null ? 1 : 0) != 0, (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ConfigurationItem ", " of type ", " does not have a control task named ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ci.getId(), ci.getType(), controlTaskName})), (Object[])new Object[0]);
        Option option = Option$.MODULE$.apply((Object)methodDescriptor.getParameterObjectType());
        if (option instanceof Some) {
            Some some = (Some)option;
            Type paramsType = (Type)some.x();
            Parameters params = (Parameters)paramsType.getDescriptor().newInstance("parameters");
            ((WrapAsScala)package$.MODULE$.wrapAll()).mapAsScalaMap(controlTaskParams).foreach((Function1)new Serializable($this, params){
                public static final long serialVersionUID = 0L;
                private final Parameters params$1;

                public final void apply(Tuple2<String, String> p) {
                    this.params$1.setProperty((String)p._1(), p._2());
                }
                {
                    this.params$1 = params$1;
                }
            });
            parameters = params;
        } else {
            parameters = null;
        }
        Parameters parameters2 = parameters;
        return new ControlTaskHolder(ci, methodDescriptor, parameters2);
    }

    public static String createTask(ControlTaskService $this, ControlTaskHolder controlTask, WorkDir workDir) {
        Buffer steps = (Buffer)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer((List)controlTask.methodDescriptor().invoke(controlTask.ci(), controlTask.parameters())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final TaskStep apply(Object x0$1) {
                Object object = x0$1;
                if (object instanceof Step) {
                    Step step = (Step)object;
                    TaskStep taskStep = new TaskStep(step);
                    return taskStep;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Control tasks with step type ", " are not supported, please use flow.Step type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object.getClass()})));
            }
        }, Buffer$.MODULE$.canBuildFrom());
        String description = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Control task [", "}] for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{controlTask.methodDescriptor().getName(), controlTask.ci().getId()}));
        TaskSpecification taskSpec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, BlockBuilders$.MODULE$.steps(description, null, package$.MODULE$.wrapAll().seqAsJavaList((Seq)steps)).build(), null, false, false, true);
        Map metadata = taskSpec.getMetadata();
        metadata.put("taskType", $this.TASK_TYPE());
        metadata.put("taskName", controlTask.methodDescriptor().getName());
        metadata.put("taskLabel", controlTask.methodDescriptor().getLabel());
        metadata.put("controlTaskTargetCI", controlTask.ci().getId());
        taskSpec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        return $this.taskExecutionEngine().register(taskSpec);
    }

    public static void executeTask(ControlTaskService $this, String taskId) {
        $this.taskExecutionEngine().execute(taskId);
    }

    public static Task retrieveTask(ControlTaskService $this, String taskId) {
        return $this.taskExecutionEngine().retrieve(taskId);
    }

    public static void cancelTask(ControlTaskService $this, String taskId) {
        $this.taskExecutionEngine().cancel(taskId);
    }

    public static void archiveTask(ControlTaskService $this, String taskId) {
        $this.taskExecutionEngine().archive(taskId);
    }

    public static void $init$(ControlTaskService $this) {
        $this.com$xebialabs$xlplatform$scheduler$ControlTaskService$_setter_$TASK_TYPE_$eq("CONTROL");
    }
}

