/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.xebialabs.deployit.engine.spi.execution.NonRemotableExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.repository.WorkDir;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkdirCleanerTrigger
implements NonRemotableExecutionStateListener {
    private List<WorkDir> workDirs = new ArrayList<WorkDir>();
    private boolean keepWorkdirsIntactOnTaskEnd;
    private static final Logger logger = LoggerFactory.getLogger(WorkdirCleanerTrigger.class);

    public WorkdirCleanerTrigger(WorkDir workDir) {
        this.workDirs.add(workDir);
    }

    public WorkdirCleanerTrigger(List<WorkDir> workDir) {
        for (WorkDir dir : workDir) {
            logger.debug("Registering workdir [{}] for cleanup on task completion.", workDir);
            this.workDirs.add(dir);
        }
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (event.currentState().isFinal()) {
            if (!this.isKeepWorkdirsIntactOnTaskEnd()) {
                logger.info("Cleaning Workdirs [{}] for task [{}]", this.workDirs, (Object)event.task().getId());
                this.cleanWorkdirs();
            } else {
                logger.info("Workdirs [{}] are kept intact for task [{}]");
            }
        }
    }

    private void cleanWorkdirs() {
        for (WorkDir workDir : this.workDirs) {
            try {
                workDir.delete();
            }
            catch (RuntimeException re) {
                logger.error("Failed to clean WorkDir [{}]", (Object)workDir);
            }
        }
    }

    public List<WorkDir> getWorkDirs() {
        return this.workDirs;
    }

    public boolean isKeepWorkdirsIntactOnTaskEnd() {
        return this.keepWorkdirsIntactOnTaskEnd;
    }

    public void setKeepWorkdirsIntactOnTaskEnd(boolean keepWorkdirsIntactOnTaskEnd) {
        this.keepWorkdirsIntactOnTaskEnd = keepWorkdirsIntactOnTaskEnd;
    }
}

