/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.api.importer;

import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class ImportedPackage {
    private Application application;
    private Version version;
    private final PackageInfo packageInfo;

    public ImportedPackage(PackageInfo packageInfo, Application application, Version version) {
        this.packageInfo = packageInfo;
        this.application = application;
        this.version = version;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public Application getApplication() {
        return this.application;
    }

    public Version getVersion() {
        return this.version;
    }

    public List<Deployable> getDeployables() {
        return new ArrayList<Deployable>(this.version.getDeployables());
    }

    @Deprecated
    public void setDeployables(List<Deployable> deployables) {
        if (!(this.version instanceof DeploymentPackage)) {
            throw new IllegalStateException(String.format("Cannot set deployables on a non udm.DeploymentPackage (%s)", this.version.getType()));
        }
        ((DeploymentPackage)this.version).setDeployables(new HashSet<Deployable>(deployables));
    }

    @Deprecated
    public void addDeployable(Deployable deployable) {
        if (!(this.version instanceof DeploymentPackage)) {
            throw new IllegalStateException(String.format("Cannot add deployables on a non udm.DeploymentPackage (%s)", this.version.getType()));
        }
        ((DeploymentPackage)this.version).addDeployable(deployable);
    }
}

