/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalDescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.overthere.util.OverthereUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDescriptorRegistry
extends DescriptorRegistry {
    private static Logger logger = LoggerFactory.getLogger(LocalDescriptorRegistry.class);
    public static final DescriptorRegistryId LOCAL_ID = new LocalDescriptorRegistryId();
    private final Map<Type, Descriptor> descriptors = new HashMap<Type, Descriptor>();
    private final HashMap<Type, Set<Type>> subtypes = new HashMap();

    protected LocalDescriptorRegistry() {
        super(LOCAL_ID);
    }

    void register(Descriptor descriptor) {
        OverthereUtils.checkState((!this.descriptors.containsKey(descriptor.getType()) ? 1 : 0) != 0, (String)"The type [%s] is already registered in XL Deploy.", (Object[])new Object[]{descriptor.getType()});
        logger.debug("Registered ConfigurationItem: {}", (Object)descriptor);
        this.descriptors.put(descriptor.getType(), descriptor);
    }

    void registerSubtype(Type supertype, Type subtype) {
        OverthereUtils.checkState((!supertype.equals((Object)subtype) ? 1 : 0) != 0, (String)"Cannot register [%s] as its own subtype.", (Object[])new Object[]{supertype});
        this.subtypes.computeIfAbsent(supertype, k -> new LinkedHashSet()).add(subtype);
    }

    protected boolean isLocal() {
        return true;
    }

    protected Collection<Descriptor> _getDescriptors() {
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    protected Collection<Type> _getSubtypes(Type supertype) {
        return Collections.unmodifiableCollection(this.subtypes.computeIfAbsent(supertype, k -> new LinkedHashSet()));
    }

    protected Descriptor _getDescriptor(Type type) {
        OverthereUtils.checkState((!this.descriptors.isEmpty() ? 1 : 0) != 0, (String)"DescriptorRegistry not booted", (Object[])new Object[0]);
        OverthereUtils.checkArgument((boolean)LocalDescriptorRegistry.exists((Type)type), (String)"Unknown type [%s]", (Object[])new Object[]{type});
        return this.descriptors.get(type);
    }

    protected boolean _exists(Type type) {
        return this.descriptors.containsKey(type);
    }
}

