/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.serialization;

import akka.actor.ActorInitializationException;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.InternalActorRef;
import akka.annotation.InternalApi;
import akka.dispatch.sysmsg.Create;
import akka.dispatch.sysmsg.DeathWatchNotification;
import akka.dispatch.sysmsg.Failed;
import akka.dispatch.sysmsg.NoMessage$;
import akka.dispatch.sysmsg.Recreate;
import akka.dispatch.sysmsg.Resume;
import akka.dispatch.sysmsg.Supervise;
import akka.dispatch.sysmsg.Suspend;
import akka.dispatch.sysmsg.SystemMessage;
import akka.dispatch.sysmsg.Terminate;
import akka.dispatch.sysmsg.Unwatch;
import akka.dispatch.sysmsg.Watch;
import akka.remote.ContainerFormats;
import akka.remote.SystemMessageFormats;
import akka.remote.serialization.WrappedPayloadSupport;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001%\u0011qcU=ti\u0016lW*Z:tC\u001e,7+\u001a:jC2L'0\u001a:\u000b\u0005\r!\u0011!D:fe&\fG.\u001b>bi&|gN\u0003\u0002\u0006\r\u00051!/Z7pi\u0016T\u0011aB\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0001\u0003\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\t\u0003#Mi\u0011A\u0005\u0006\u0003\u0007\u0019I!\u0001\u0006\n\u0003\u001d\t\u000b7/Z*fe&\fG.\u001b>fe\"Aa\u0003\u0001BC\u0002\u0013\u0005q#\u0001\u0004tsN$X-\\\u000b\u00021A\u0011\u0011\u0004H\u0007\u00025)\u00111DB\u0001\u0006C\u000e$xN]\u0005\u0003;i\u00111#\u0012=uK:$W\rZ!di>\u00148+_:uK6D\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\bgf\u001cH/Z7!\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00111%\n\t\u0003I\u0001i\u0011A\u0001\u0005\u0006-\u0001\u0002\r\u0001\u0007\u0005\t\u0007\u0001A)\u0019!C\u0005OU\t\u0001\u0006\u0005\u0002\u0012S%\u0011!F\u0005\u0002\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\t\u000f1\u0002!\u0019!C\u0005[\u0005q\u0001/Y=m_\u0006$7+\u001e9q_J$X#\u0001\u0018\u0011\u0005\u0011z\u0013B\u0001\u0019\u0003\u0005U9&/\u00199qK\u0012\u0004\u0016-\u001f7pC\u0012\u001cV\u000f\u001d9peRDaA\r\u0001!\u0002\u0013q\u0013a\u00049bs2|\u0017\rZ*vaB|'\u000f\u001e\u0011\t\u000bQ\u0002A\u0011I\u001b\u0002\u001f%t7\r\\;eK6\u000bg.\u001b4fgR,\u0012A\u000e\t\u0003\u0017]J!\u0001\u000f\u0007\u0003\u000f\t{w\u000e\\3b]\")!\b\u0001C!w\u0005AAo\u001c\"j]\u0006\u0014\u0018\u0010\u0006\u0002=\u0005B\u00191\"P \n\u0005yb!!B!se\u0006L\bCA\u0006A\u0013\t\tEB\u0001\u0003CsR,\u0007\"B\":\u0001\u0004Q\u0011!A8\t\u000b\u0015\u0003A\u0011\t$\u0002\u0015\u0019\u0014x.\u001c\"j]\u0006\u0014\u0018\u0010F\u0002\u000b\u000f&CQ\u0001\u0013#A\u0002q\nQAY=uKNDQA\u0013#A\u0002-\u000b\u0001\"\\1oS\u001a,7\u000f\u001e\t\u0004\u00171s\u0015BA'\r\u0005\u0019y\u0005\u000f^5p]B\u0012q\n\u0018\t\u0004!^SfBA)V!\t\u0011F\"D\u0001T\u0015\t!\u0006\"\u0001\u0004=e>|GOP\u0005\u0003-2\ta\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0015\u0019E.Y:t\u0015\t1F\u0002\u0005\u0002\\92\u0001A!C/J\u0003\u0003\u0005\tQ!\u0001_\u0005\ryF%M\t\u0003?\n\u0004\"a\u00031\n\u0005\u0005d!a\u0002(pi\"Lgn\u001a\t\u0003\u0017\rL!\u0001\u001a\u0007\u0003\u0007\u0005s\u0017\u0010C\u0003g\u0001\u0011%q-\u0001\reKN,'/[1mSj,7+_:uK6lUm]:bO\u0016$\"\u0001\u001b9\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017AB:zg6\u001cxM\u0003\u0002n\r\u0005AA-[:qCR\u001c\u0007.\u0003\u0002pU\ni1+_:uK6lUm]:bO\u0016DQa[3A\u0002E\u0004\"A\u001d<\u000f\u0005M$X\"\u0001\u0003\n\u0005U$\u0011\u0001F*zgR,W.T3tg\u0006<WMR8s[\u0006$8/\u0003\u0002po*\u0011Q\u000f\u0002\u0005\u0006s\u0002!IA_\u0001\u0013g\u0016\u0014\u0018.\u00197ju\u0016$\u0006N]8xC\ndW\rF\u0002|\u0003\u001b\u00012\u0001`A\u0004\u001d\ri\u0018\u0011\u0001\b\u0003gzL!a \u0003\u0002!\r{g\u000e^1j]\u0016\u0014hi\u001c:nCR\u001c\u0018\u0002BA\u0002\u0003\u000b\tq\u0001U1zY>\fGM\u0003\u0002\u0000\t%!\u0011\u0011BA\u0006\u0005\u001d\u0011U/\u001b7eKJTA!a\u0001\u0002\u0006!9\u0011q\u0002=A\u0002\u0005E\u0011!\u0003;ie><\u0018M\u00197f!\u0011\t\u0019\"!\b\u000f\t\u0005U\u0011\u0011\u0004\b\u0004%\u0006]\u0011\"A\u0007\n\u0007\u0005mA\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0011\u0011\u0005\u0002\n)\"\u0014xn^1cY\u0016T1!a\u0007\r\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\t\u0011cZ3u\u0007\u0006,8/\u001a+ie><\u0018M\u00197f)\u0011\t\t\"!\u000b\t\u000f\u0005-\u00121\u0005a\u0001c\u0006\u0019Qn]4\t\u000f\u0005=\u0002\u0001\"\u0003\u00022\u0005\t2/\u001a:jC2L'0Z!di>\u0014(+\u001a4\u0015\t\u0005M\u0012q\b\t\u0005\u0003k\tYDD\u0002~\u0003oIA!!\u000f\u0002\u0006\u0005A\u0011i\u0019;peJ+g-\u0003\u0003\u0002\n\u0005u\"\u0002BA\u001d\u0003\u000bA\u0001\"!\u0011\u0002.\u0001\u0007\u00111I\u0001\tC\u000e$xN\u001d*fMB\u0019\u0011$!\u0012\n\u0007\u0005\u001d#D\u0001\u0005BGR|'OU3g\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b\n1\u0003Z3tKJL\u0017\r\\5{K\u0006\u001bGo\u001c:SK\u001a$B!a\u0011\u0002P!A\u0011\u0011KA%\u0001\u0004\t\u0019&A\u0007tKJL\u0017\r\\5{K\u0012\u0014VM\u001a\t\u0004{\u0006U\u0013\u0002BA$\u0003\u000b\u0001")
public class SystemMessageSerializer
implements BaseSerializer {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private final WrappedPayloadSupport payloadSupport;
    private final int identifier;
    private volatile boolean bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public int identifier() {
        return this.identifier;
    }

    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization$lzycompute() {
        SystemMessageSerializer systemMessageSerializer = this;
        synchronized (systemMessageSerializer) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        return !this.bitmap$0 ? this.serialization$lzycompute() : this.serialization;
    }

    private WrappedPayloadSupport payloadSupport() {
        return this.payloadSupport;
    }

    public boolean includeManifest() {
        return false;
    }

    public byte[] toBinary(Object o) {
        SystemMessageFormats.SystemMessage.Builder builder;
        SystemMessageFormats.SystemMessage.Builder builder2 = SystemMessageFormats.SystemMessage.newBuilder();
        SystemMessage systemMessage = (SystemMessage)o;
        if (systemMessage instanceof Create) {
            Object object;
            Create create = (Create)systemMessage;
            Option failure = create.failure();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.CREATE);
            Option option = failure;
            if (option instanceof Some) {
                Some some = (Some)option;
                ActorInitializationException throwable = (ActorInitializationException)some.value();
                object = builder2.setCauseData(this.serializeThrowable((Throwable)throwable));
            } else if (None$.MODULE$.equals(option)) {
                object = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            builder = object;
        } else if (systemMessage instanceof Recreate) {
            Recreate recreate = (Recreate)systemMessage;
            Throwable cause = recreate.cause();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.RECREATE);
            builder = builder2.setCauseData(this.serializeThrowable(cause));
        } else if (systemMessage instanceof Suspend) {
            builder = builder2.setType(SystemMessageFormats.SystemMessage.Type.SUSPEND);
        } else if (systemMessage instanceof Resume) {
            Resume resume = (Resume)systemMessage;
            Throwable cause = resume.causedByFailure();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.RESUME);
            builder = builder2.setCauseData(this.serializeThrowable(cause));
        } else if (systemMessage instanceof Terminate) {
            builder = builder2.setType(SystemMessageFormats.SystemMessage.Type.TERMINATE);
        } else if (systemMessage instanceof Supervise) {
            Supervise supervise = (Supervise)systemMessage;
            ActorRef child = supervise.child();
            boolean async = supervise.async();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.SUPERVISE);
            SystemMessageFormats.SuperviseData.Builder superviseData = SystemMessageFormats.SuperviseData.newBuilder().setChild(this.serializeActorRef(child)).setAsync(async);
            builder = builder2.setSuperviseData(superviseData);
        } else if (systemMessage instanceof Watch) {
            Watch watch = (Watch)systemMessage;
            InternalActorRef watchee = watch.watchee();
            InternalActorRef watcher = watch.watcher();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.WATCH);
            SystemMessageFormats.WatchData.Builder watchData = SystemMessageFormats.WatchData.newBuilder().setWatchee(this.serializeActorRef((ActorRef)watchee)).setWatcher(this.serializeActorRef((ActorRef)watcher));
            builder = builder2.setWatchData(watchData);
        } else if (systemMessage instanceof Unwatch) {
            Unwatch unwatch = (Unwatch)systemMessage;
            ActorRef watchee = unwatch.watchee();
            ActorRef watcher = unwatch.watcher();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.UNWATCH);
            SystemMessageFormats.WatchData.Builder watchData = SystemMessageFormats.WatchData.newBuilder().setWatchee(this.serializeActorRef(watchee)).setWatcher(this.serializeActorRef(watcher));
            builder = builder2.setWatchData(watchData);
        } else if (systemMessage instanceof Failed) {
            Failed failed = (Failed)systemMessage;
            ActorRef child = failed.child();
            Throwable cause = failed.cause();
            int uid = failed.uid();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.FAILED);
            SystemMessageFormats.FailedData.Builder failedData = SystemMessageFormats.FailedData.newBuilder().setChild(this.serializeActorRef(child)).setUid(uid);
            builder2.setCauseData(this.serializeThrowable(cause));
            builder = builder2.setFailedData(failedData);
        } else if (systemMessage instanceof DeathWatchNotification) {
            DeathWatchNotification deathWatchNotification = (DeathWatchNotification)systemMessage;
            ActorRef actor = deathWatchNotification.actor();
            boolean existenceConfirmed = deathWatchNotification.existenceConfirmed();
            boolean addressTerminated = deathWatchNotification.addressTerminated();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.DEATHWATCH_NOTIFICATION);
            SystemMessageFormats.DeathWatchNotificationData.Builder deathWatchNotificationData = SystemMessageFormats.DeathWatchNotificationData.newBuilder().setActor(this.serializeActorRef(actor)).setExistenceConfirmed(existenceConfirmed).setAddressTerminated(addressTerminated);
            builder = builder2.setDwNotificationData(deathWatchNotificationData);
        } else {
            if (NoMessage$.MODULE$.equals(systemMessage)) {
                throw new IllegalArgumentException("NoMessage should never be serialized or deserialized");
            }
            throw new MatchError((Object)systemMessage);
        }
        return builder2.build().toByteArray();
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return this.deserializeSystemMessage(SystemMessageFormats.SystemMessage.parseFrom(bytes));
    }

    private SystemMessage deserializeSystemMessage(SystemMessageFormats.SystemMessage sysmsg) {
        Create create;
        SystemMessageFormats.SystemMessage.Type type = sysmsg.getType();
        if (((Object)((Object)SystemMessageFormats.SystemMessage.Type.CREATE)).equals((Object)type)) {
            None$ cause = sysmsg.hasCauseData() ? new Some((Object)((ActorInitializationException)this.getCauseThrowable(sysmsg))) : None$.MODULE$;
            create = new Create((Option)cause);
        } else if (((Object)((Object)SystemMessageFormats.SystemMessage.Type.RECREATE)).equals((Object)type)) {
            create = new Recreate(this.getCauseThrowable(sysmsg));
        } else if (((Object)((Object)SystemMessageFormats.SystemMessage.Type.SUSPEND)).equals((Object)type)) {
            create = new Suspend();
        } else if (((Object)((Object)SystemMessageFormats.SystemMessage.Type.RESUME)).equals((Object)type)) {
            create = new Resume(this.getCauseThrowable(sysmsg));
        } else if (((Object)((Object)SystemMessageFormats.SystemMessage.Type.TERMINATE)).equals((Object)type)) {
            create = new Terminate();
        } else if (((Object)((Object)SystemMessageFormats.SystemMessage.Type.SUPERVISE)).equals((Object)type)) {
            create = new Supervise(this.deserializeActorRef(sysmsg.getSuperviseData().getChild()), sysmsg.getSuperviseData().getAsync());
        } else if (((Object)((Object)SystemMessageFormats.SystemMessage.Type.WATCH)).equals((Object)type)) {
            create = new Watch((InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatchee()), (InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatcher()));
        } else if (((Object)((Object)SystemMessageFormats.SystemMessage.Type.UNWATCH)).equals((Object)type)) {
            create = new Unwatch((ActorRef)((InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatchee())), (ActorRef)((InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatcher())));
        } else if (((Object)((Object)SystemMessageFormats.SystemMessage.Type.FAILED)).equals((Object)type)) {
            create = new Failed(this.deserializeActorRef(sysmsg.getFailedData().getChild()), this.getCauseThrowable(sysmsg), (int)sysmsg.getFailedData().getUid());
        } else if (((Object)((Object)SystemMessageFormats.SystemMessage.Type.DEATHWATCH_NOTIFICATION)).equals((Object)type)) {
            create = new DeathWatchNotification(this.deserializeActorRef(sysmsg.getDwNotificationData().getActor()), sysmsg.getDwNotificationData().getExistenceConfirmed(), sysmsg.getDwNotificationData().getAddressTerminated());
        } else {
            throw new MatchError((Object)type);
        }
        return create;
    }

    private ContainerFormats.Payload.Builder serializeThrowable(Throwable throwable) {
        return this.payloadSupport().payloadBuilder(throwable);
    }

    private Throwable getCauseThrowable(SystemMessageFormats.SystemMessage msg) {
        return (Throwable)this.payloadSupport().deserializePayload(msg.getCauseData());
    }

    private ContainerFormats.ActorRef.Builder serializeActorRef(ActorRef actorRef) {
        return ContainerFormats.ActorRef.newBuilder().setPath(Serialization$.MODULE$.serializedActorPath(actorRef));
    }

    private ActorRef deserializeActorRef(ContainerFormats.ActorRef serializedRef) {
        return this.serialization().system().provider().resolveActorRef(serializedRef.getPath());
    }

    public SystemMessageSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$((Serializer)this);
        BaseSerializer.$init$((BaseSerializer)this);
        this.payloadSupport = new WrappedPayloadSupport(system);
    }
}

