/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployfile.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.DeployfileService;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.deployfile.DirectorySpec;
import com.xebialabs.deployit.deployfile.ForDirectories;
import com.xebialabs.deployit.deployfile.XldSpec;
import com.xebialabs.deployit.deployfile.execute.CiCommand;
import com.xebialabs.deployit.deployfile.execute.CiCommandCreator;
import com.xebialabs.deployit.deployfile.execute.CommandExecutor;
import com.xebialabs.deployit.deployfile.execute.DeleteCiCommand;
import com.xebialabs.deployit.deployfile.execute.DeployfileCommand;
import com.xebialabs.deployit.deployfile.execute.DeployfileExecutor;
import com.xebialabs.deployit.deployfile.execute.DeployfileReferenceResolver;
import com.xebialabs.deployit.deployfile.export.DeployfileGenerator;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.validation.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u00015\u0011!\u0003R3qY>Lh-\u001b7f%\u0016\u001cx.\u001e:dK*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003)!W\r\u001d7ps\u001aLG.\u001a\u0006\u0003\u000f!\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u00192\u0001\u0001\b\u0019!\tya#D\u0001\u0011\u0015\t\t\"#A\u0004tK\u000e,(/\u001a3\u000b\u0005M!\u0012\u0001\u0002:fgRT!!\u0006\u0004\u0002\t\r|'/Z\u0005\u0003/A\u0011q#\u00112tiJ\f7\r^*fGV\u0014X\r\u001a*fg>,(oY3\u0011\u0005eYR\"\u0001\u000e\u000b\u0005\r!\u0012B\u0001\u000f\u001b\u0005E!U\r\u001d7ps\u001aLG.Z*feZL7-\u001a\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u0005\t\"/\u001a9pg&$xN]=TKJ4\u0018nY3\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t2\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011A%\t\u0002\u0012%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002'\u0011,\u0007\u000f\\8zM&dWmR3oKJ\fGo\u001c:\u0011\u0005!ZS\"A\u0015\u000b\u0005)\"\u0011AB3ya>\u0014H/\u0003\u0002-S\t\u0019B)\u001a9m_f4\u0017\u000e\\3HK:,'/\u0019;pe\"Aa\u0006\u0001B\u0001B\u0003%q&\u0001\neKBdw.\u001f4jY\u0016,\u00050Z2vi>\u0014\bC\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0005\u0003\u001d)\u00070Z2vi\u0016L!\u0001N\u0019\u0003%\u0011+\u0007\u000f\\8zM&dW-\u0012=fGV$xN\u001d\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u0005YB-\u001a9m_f4\u0017\u000e\\3SK\u001a,'/\u001a8dKJ+7o\u001c7wKJ\u0004\"\u0001\r\u001d\n\u0005e\n$a\u0007#fa2|\u0017PZ5mKJ+g-\u001a:f]\u000e,'+Z:pYZ,'\u000f\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u00039\u0019w.\\7b]\u0012\u001c%/Z1u_J\u0004\"\u0001M\u001f\n\u0005y\n$\u0001E\"j\u0007>lW.\u00198e\u0007J,\u0017\r^8s\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0015aD2p[6\fg\u000eZ#yK\u000e,Ho\u001c:\u0011\u0005A\u0012\u0015BA\"2\u0005=\u0019u.\\7b]\u0012,\u00050Z2vi>\u0014\b\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u0013Y\fG.\u001b3bi>\u0014\bCA$M\u001b\u0005A%BA%K\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u0017\u001a\tqa]3sm&\u001cW-\u0003\u0002N\u0011\nIa+\u00197jI\u0006$xN\u001d\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011E\u001bF+\u0016,X1f\u0003\"A\u0015\u0001\u000e\u0003\tAQA\b(A\u0002}AQA\n(A\u0002\u001dBQA\f(A\u0002=BQA\u000e(A\u0002]BQa\u000f(A\u0002qBQ\u0001\u0011(A\u0002\u0005CQ!\u0012(A\u0002\u0019C#AT.\u0011\u0005q;W\"A/\u000b\u0005y{\u0016AC1o]>$\u0018\r^5p]*\u0011\u0001-Y\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u00117-A\u0003cK\u0006t7O\u0003\u0002eK\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001g\u0003\ry'oZ\u0005\u0003Qv\u0013\u0011\"Q;u_^L'/\u001a3\t\u000b)\u0004A\u0011A6\u0002\u0011\u001d,g.\u001a:bi\u0016$\"\u0001\\=\u0011\u000554hB\u00018u!\ty'/D\u0001q\u0015\t\tH\"\u0001\u0004=e>|GO\u0010\u0006\u0002g\u0006)1oY1mC&\u0011QO]\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002ve\")!0\u001ba\u0001w\u00069am\u001c7eKJ\u001c\b\u0003\u0002?\u0002\u00041l\u0011! \u0006\u0003}~\fA!\u001e;jY*\u0011\u0011\u0011A\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0006u\u0014A\u0001T5ti\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011!B1qa2LH\u0003BA\u0007\u0003+\u0001B!a\u0004\u0002\u00125\t!/C\u0002\u0002\u0014I\u0014A!\u00168ji\"1Q!a\u0002A\u00021Dq!!\u0007\u0001\t\u0003\tY\"\u0001\rdQ\u0016\u001c7nQ8oI&$\u0018n\u001c8P]bcGm\u00159fGN$b!!\u0004\u0002\u001e\u0005}\u0002\u0002CA\u0010\u0003/\u0001\r!!\t\u0002\u0013\r|g\u000eZ5uS>t\u0007\u0003CA\b\u0003G\t9#!\u0004\n\u0007\u0005\u0015\"OA\u0005Gk:\u001cG/[8ocA1\u0011\u0011FA\u001a\u0003oqA!a\u000b\u000209\u0019q.!\f\n\u0003ML1!!\rs\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0002\u00026)\u0019\u0011\u0011\u0007:\u0011\t\u0005e\u00121H\u0007\u0002\t%\u0019\u0011Q\b\u0003\u0003\u001b\u0011K'/Z2u_JL8\u000b]3d\u0011!\t\t%a\u0006A\u0002\u0005\r\u0013\u0001\u0003=mIN\u0003XmY:\u0011\r\u0005%\u00121GA#!\u0011\tI$a\u0012\n\u0007\u0005%CAA\u0004YY\u0012\u001c\u0006/Z2\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u0005i2\r[3dWB+'/\\5tg&|gNR8s\t&\u0014Xm\u0019;pe&,7\u000f\u0006\u0003\u0002\u000e\u0005E\u0003\u0002CA*\u0003\u0017\u0002\r!a\n\u0002\t\u0011L'o\u001d\u0005\b\u0003/\u0002A\u0011AA-\u0003m\u0019\u0007.Z2l!\u0016\u0014X.[:tS>tgi\u001c:ESJ,7\r^8ssR!\u0011QBA.\u0011!\ti&!\u0016A\u0002\u0005]\u0012a\u00013je\"9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0014AH2iK\u000e\\7+Z2ve&$\u0018\u0010U3s[&\u001c8/[8o\r>\u0014Xk]3s)\u0011\ti!!\u001a\t\u0011\u0005M\u0013q\fa\u0001\u0003OAq!!\u001b\u0001\t\u0013\tY'\u0001\u0007dCN$\u0018I\u001c3DQ\u0016\u001c7.\u0006\u0003\u0002n\u0005MDCBA8\u0003#\u000b)\n\u0005\u0003\u0002r\u0005MD\u0002\u0001\u0003\t\u0003k\n9G1\u0001\u0002x\t\tA+\u0005\u0003\u0002z\u0005}\u0004\u0003BA\b\u0003wJ1!! s\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!!\u0002\u000e6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0002vI6T1aAAE\u0015\r\tYIB\u0001\u0007a2,x-\u001b8\n\t\u0005=\u00151\u0011\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007\u0002CAJ\u0003O\u0002\r!a \u0002\u0005\rL\u0007\u0002CAL\u0003O\u0002\r!!'\u0002\u000b\rd\u0017M\u001f>\u0011\u000b5\fY*a\u001c\n\u0007\u0005u\u0005PA\u0003DY\u0006\u001c8\u000f\u0003\u0007\u0002\"\u0002\u0001\n\u0011!A\u0001\n\u0003\t\u0019+A\rqe>$Xm\u0019;fI\u0012\u001a\u0007.Z2l!\u0016\u0014X.[:tS>tG\u0003BAS\u0003\u0013$b!!\u0004\u0002(\u0006m\u0006BCAU\u0003?\u000b\t\u00111\u0001\u0002,\u0006\u0019\u0001\u0010J\u0019\u0011\t\u00055\u0016qW\u0007\u0003\u0003_SA!!-\u00024\u0006Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\u000b\u0007\u0005Uf!\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\tI,a,\u0003\u0015A+'/\\5tg&|g\u000e\u0003\u0006\u0002>\u0006}\u0015\u0011!a\u0001\u0003\u007f\u000b1\u0001\u001f\u00133!\u0011\t\t-a2\u000e\u0005\u0005\r'bAAc\u007f\u0006!A.\u00198h\u0013\r9\u00181\u0019\u0005\n\u0003S\u000by*!AA\u0002EC3\u0001AAg!\u0011\ty-!6\u000e\u0005\u0005E'bAAjG\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005]\u0017\u0011\u001b\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b")
public class DeployfileResource
extends AbstractSecuredResource
implements DeployfileService {
    private final RepositoryService repositoryService;
    private final DeployfileGenerator deployfileGenerator;
    private final DeployfileExecutor deployfileExecutor;
    private final DeployfileReferenceResolver deployfileReferenceResolver;
    private final CiCommandCreator commandCreator;
    private final CommandExecutor commandExecutor;
    private final Validator validator;

    public /* synthetic */ void protected$checkPermission(DeployfileResource x$1, Permission x$12, String x$2) {
        x$1.checkPermission(x$12, x$2);
    }

    public String generate(java.util.List<String> folders) {
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(folders).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.protected$checkPermission(this, DeployitPermissions.GENERATE_DEPLOY_FILE, x$1);
            return BoxedUnit.UNIT;
        });
        List directories = ((TraversableOnce)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.repositoryService.read(folders, 0, false)).map((Function1 & Serializable & scala.Serializable)x$2 -> this.castAndCheck((ConfigurationItem)x$2, (Class)Directory.class), Buffer$.MODULE$.canBuildFrom())).toList();
        return this.deployfileGenerator.generate((List<Directory>)directories);
    }

    public void apply(String deployfile) {
        List<XldSpec> xldSpecs = this.deployfileExecutor.execute(deployfile);
        this.checkConditionOnXldSpecs((Function1<List<DirectorySpec>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dirs -> {
            this.checkPermissionForDirectories((List<DirectorySpec>)dirs);
            return BoxedUnit.UNIT;
        }, xldSpecs);
        this.checkConditionOnXldSpecs((Function1<List<DirectorySpec>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dirs -> {
            this.checkSecurityPermissionForUser((List<DirectorySpec>)dirs);
            return BoxedUnit.UNIT;
        }, xldSpecs);
        List commands = (List)xldSpecs.flatMap((Function1 & Serializable & scala.Serializable)spec -> {
            $this.deployfileReferenceResolver.resolveAll((XldSpec)spec);
            return $this.commandCreator.create((XldSpec)spec);
        }, List$.MODULE$.canBuildFrom());
        this.validator.validateCis(new ArrayList(ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)commands.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            DeployfileCommand deployfileCommand = x0$1;
            if (deployfileCommand instanceof DeleteCiCommand) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else if (deployfileCommand instanceof CiCommand) {
                CiCommand ciCommand = (CiCommand)deployfileCommand;
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ciCommand.ci()));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom()))));
        this.commandExecutor.execute((List<DeployfileCommand>)commands);
    }

    public void checkConditionOnXldSpecs(Function1<List<DirectorySpec>, BoxedUnit> condition, List<XldSpec> xldSpecs) {
        ((List)((List)xldSpecs.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(x$3.getScopes()), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getForDirectories(), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)dirs -> {
            DeployfileResource.$anonfun$checkConditionOnXldSpecs$3(condition, dirs);
            return BoxedUnit.UNIT;
        });
    }

    public void checkPermissionForDirectories(List<DirectorySpec> dirs) {
        dirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.checkPermissionForDirectory(dir);
            return BoxedUnit.UNIT;
        });
    }

    public void checkPermissionForDirectory(DirectorySpec dir) {
        block0: {
            if (dir.getId() == null) break block0;
            String idToCheck = this.repositoryService.exists(dir.getId()) ? dir.getId() : JcrPathHelper.getParentId((String)dir.getId());
            this.checkPermission(PlatformPermissions.EDIT_REPO, idToCheck);
        }
    }

    public void checkSecurityPermissionForUser(List<DirectorySpec> dirs) {
        block0: {
            if (!((TraversableOnce)dirs.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getPermissions(), List$.MODULE$.canBuildFrom())).nonEmpty()) break block0;
            this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        }
    }

    private <T extends ConfigurationItem> T castAndCheck(ConfigurationItem ci, Class<T> clazz) {
        Checks.checkArgument((boolean)clazz.isAssignableFrom(ci.getClass()), (String)"%s is not a %s", (Object[])new Object[]{ci, clazz.getSimpleName()});
        return (T)((ConfigurationItem)clazz.cast(ci));
    }

    public static final /* synthetic */ void $anonfun$checkConditionOnXldSpecs$3(Function1 condition$1, ForDirectories dirs) {
        List list = Option$.MODULE$.apply((Object)dirs.getForEnvironments()).toList();
        List specs = Option$.MODULE$.apply((Object)dirs.getForInfrastructure()).toList().$colon$colon$colon(list);
        condition$1.apply((Object)specs);
    }

    @Autowired
    public DeployfileResource(RepositoryService repositoryService, DeployfileGenerator deployfileGenerator, DeployfileExecutor deployfileExecutor, DeployfileReferenceResolver deployfileReferenceResolver, CiCommandCreator commandCreator, CommandExecutor commandExecutor, Validator validator) {
        this.repositoryService = repositoryService;
        this.deployfileGenerator = deployfileGenerator;
        this.deployfileExecutor = deployfileExecutor;
        this.deployfileReferenceResolver = deployfileReferenceResolver;
        this.commandCreator = commandCreator;
        this.commandExecutor = commandExecutor;
        this.validator = validator;
    }
}

