/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionImpl
extends NodeImpl
implements Version {
    private static Logger log = LoggerFactory.getLogger((Class)VersionImpl.class);

    public VersionImpl(ItemManager itemMgr, SessionImpl session, AbstractNodeData data) {
        super(itemMgr, session, data);
    }

    protected InternalVersion getInternalVersion() throws RepositoryException {
        InternalVersion version = this.session.getVersionManager().getVersion((NodeId)this.id);
        if (version == null) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
        return version;
    }

    public Calendar getCreated() throws RepositoryException {
        return this.getInternalVersion().getCreated();
    }

    public Version[] getSuccessors() throws RepositoryException {
        InternalVersion[] suc = this.getInternalVersion().getSuccessors();
        Version[] ret = new Version[suc.length];
        for (int i = 0; i < suc.length; ++i) {
            ret[i] = (Version)this.session.getNodeById(suc[i].getId());
        }
        return ret;
    }

    public Version[] getPredecessors() throws RepositoryException {
        InternalVersion[] pred = this.getInternalVersion().getPredecessors();
        Version[] ret = new Version[pred.length];
        for (int i = 0; i < pred.length; ++i) {
            ret[i] = (Version)this.session.getNodeById(pred[i].getId());
        }
        return ret;
    }

    public VersionHistory getContainingHistory() throws RepositoryException {
        return (VersionHistory)this.getParent();
    }

    public InternalFrozenNode getFrozenNode() throws RepositoryException {
        return this.getInternalVersion().getFrozenNode();
    }

    public boolean isSame(Item otherItem) {
        if (otherItem instanceof VersionImpl) {
            try {
                InternalVersion other = ((VersionImpl)otherItem).getInternalVersion();
                return other.getId().equals(this.getInternalVersion().getId());
            }
            catch (RepositoryException e) {
                log.warn("Unable to retrieve internal version objects: " + e.getMessage());
                log.debug("Stack dump:", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isMoreRecent(VersionImpl v) throws RepositoryException {
        return this.getInternalVersion().isMoreRecent(v.getInternalVersion());
    }

    public boolean isRootVersion() throws RepositoryException {
        return this.getInternalVersion().isRootVersion();
    }

    public void update(String srcWorkspaceName) throws ConstraintViolationException {
        String msg = "update operation not allowed: " + this;
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws ConstraintViolationException {
        String msg = "merge operation not allowed: " + this;
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    public String toString() {
        return "version " + super.toString();
    }
}

