/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.JcrCredentials;
import com.xebialabs.deployit.Recovery;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.jackrabbit.JackrabbitRepositoryConfigurationFactoryBean;
import com.xebialabs.deployit.jcr.jackrabbit.JackrabbitRepositoryInitializer;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitRecovery
extends Recovery {
    private final Logger logger = LoggerFactory.getLogger(JackrabbitRecovery.class);
    private JackrabbitRepositoryFactoryBean factory;
    private XlRepositoryConfig xlRepositoryConfig;

    public JackrabbitRecovery(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile, XlRepositoryConfig xlRepositoryConfig) {
        super(launchOptions, serverConfigFile);
        this.xlRepositoryConfig = xlRepositoryConfig;
    }

    private Repository bootRepository(XlRepositoryConfig xlRepositoryConfig) {
        try {
            RepositoryConfig repoConfig = new JackrabbitRepositoryConfigurationFactoryBean(xlRepositoryConfig, false).getObject();
            JackrabbitRepositoryInitializer initializer = new JackrabbitRepositoryInitializer(xlRepositoryConfig);
            this.factory = new JackrabbitRepositoryFactoryBean(repoConfig, initializer);
            this.factory.initialize();
            return this.factory.getObject();
        }
        catch (Exception e) {
            throw new RuntimeIOException("Unable to boot Jackrabbit repository for recovery.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        this.logger.info("Setting JackRabbit recovery property");
        System.getProperties().setProperty("org.apache.jackrabbit.version.recovery", "true");
        try {
            JcrCredentials repoCredentials = (JcrCredentials)this.xlRepositoryConfig.credentials();
            Repository repository = this.bootRepository(this.xlRepositoryConfig);
            JcrTemplate jcrTemplate = new JcrTemplate(repository, repoCredentials.creds());
            this.logger.info("Logging into the Jackrabbit Repository");
            jcrTemplate.login();
            jcrTemplate.execute(session -> {
                RawRepositoryImpl rawRepository = new RawRepositoryImpl(session);
                this.recoverNodes(rawRepository);
                this.logger.info("Finished recovery of the repository.");
                session.save();
                return null;
            });
        }
        finally {
            this.logger.info("Shutting down the repository.");
            if (this.factory != null) {
                this.factory.destroy();
            }
        }
    }

    private void recoverNodes(RawRepositoryImpl rawRepository) throws RepositoryException {
        Collection allTypes = Collections2.transform((Collection)DescriptorRegistry.getDescriptors(), Descriptor::getType);
        for (Type type : allTypes) {
            this.logger.debug("Checking nodes of type [{}]", (Object)type);
            List nodesByType = rawRepository.findNodesByType(type);
            this.detectAndRecoverBrokenNodes(nodesByType);
        }
    }

    private void detectAndRecoverBrokenNodes(List<Node> nodesByType) throws RepositoryException {
        for (Node node : nodesByType) {
            this.logger.debug("Inspecting node [{}]", (Object)node.getName());
            ArrayList strings = Lists.newArrayList((Object[])new String[]{"{http://www.jcp.org/jcr/mix/1.0}referenceable", "{http://www.jcp.org/jcr/mix/1.0}versionable"});
            for (String mixin : strings) {
                this.checkAndRecoverMixin(node, mixin);
            }
        }
    }

    private void checkAndRecoverMixin(Node node, String mixin) throws RepositoryException {
        if (!node.isNodeType(mixin)) {
            this.logger.info("Adding missing mixin [{}] to node [{}]", (Object)mixin, (Object)node.getName());
            node.addMixin(mixin);
        }
    }
}

