/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;

public class BasicAuthOverridingHttpSessionSecurityContextRepository
extends HttpSessionSecurityContextRepository {
    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        if (this.isBasicAuth(request)) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            return;
        }
        super.saveContext(context, request, response);
    }

    private boolean isBasicAuth(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        return authorization != null && authorization.contains("Basic ");
    }
}

