/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import org.agrona.MutableDirectBuffer;

public class ImageMessageFlyweight {
    private static final int CORRELATION_ID_OFFSET = 0;
    private static final int STREAM_ID_FIELD_OFFSET = 8;
    private static final int CHANNEL_OFFSET = 12;
    private MutableDirectBuffer buffer;
    private int offset;
    private int lengthOfChannel;

    public final ImageMessageFlyweight wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 0);
    }

    public ImageMessageFlyweight correlationId(long correlationId) {
        this.buffer.putLong(this.offset + 0, correlationId);
        return this;
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 8);
    }

    public ImageMessageFlyweight streamId(int streamId) {
        this.buffer.putInt(this.offset + 8, streamId);
        return this;
    }

    public String channel() {
        int length = this.buffer.getInt(this.offset + 12);
        this.lengthOfChannel = 4 + length;
        return this.buffer.getStringAscii(this.offset + 12, length);
    }

    public ImageMessageFlyweight channel(String channel) {
        this.lengthOfChannel = this.buffer.putStringAscii(this.offset + 12, channel);
        return this;
    }

    public int length() {
        return 12 + this.lengthOfChannel;
    }
}

