/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.DateHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

@CliObject(name="task2")
@ClassHelp(description="Access to the task block engine of XL Deploy.")
public class TaskBlockClient
extends DocumentedObject {
    private ProxiesInstance proxies;

    public TaskBlockClient() {
    }

    public TaskBlockClient(ProxiesInstance proxies) {
        this.proxies = proxies;
    }

    @MethodHelp(description="Lists the active tasks of the logged in user.", returns="A list of tasks with blocks but without step information")
    public List<TaskWithBlock> getMyCurrentTasks() {
        return this.proxies.getTaskBlockRegistry().getMyCurrentTasks();
    }

    @MethodHelp(description="Lists the active tasks of all users. Requires admin permission.", returns="A list of tasks with blocks but without step information")
    public List<TaskWithBlock> getAllCurrentTasks() {
        return this.proxies.getTaskBlockRegistry().getAllCurrentTasks();
    }

    @MethodHelp(description="Gets the task.", parameters={@ParameterHelp(name="taskId", description="The id of the task.")}, returns="The task with blocks but without step information.")
    public TaskWithBlock get(String taskId) {
        return this.proxies.getTaskBlockRegistry().getTask(taskId);
    }

    @MethodHelp(description="Gets the task.", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="blockId", description="The id of the block.")}, returns="The task with blocks but without step information.")
    public BlockState block(String taskId, String blockId) {
        return this.proxies.getTaskBlockRegistry().getBlock(taskId, blockId);
    }

    @MethodHelp(description="Gets the task with steps.", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="blockId", description="The id of the block.")}, returns="The task, containing step information.")
    public StepBlockState steps(String taskId, String blockId) {
        return this.proxies.getTaskBlockRegistry().getSteps(taskId, blockId);
    }

    @MethodHelp(description="Gets information about a step.", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="stepId", description="The position of the step in the step list.")}, returns="The step info.")
    public StepState step(String taskId, String stepId) {
        return this.proxies.getTaskBlockRegistry().getStep(taskId, stepId, null);
    }

    @MethodHelp(description="Starts a task.", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void start(String taskId) {
        this.proxies.getTaskBlockRegistry().start(taskId);
    }

    @MethodHelp(description="Schedule a task for execution in the (near) future.", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="dateTime", description="The date and time of scheduled execution.")})
    public void schedule(String taskId, DateTime dateTime) {
        this.proxies.getTaskBlockRegistry().schedule(taskId, dateTime);
    }

    @MethodHelp(description="Gracefully stops an active task.", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void stop(String taskId) {
        this.proxies.getTaskBlockRegistry().stop(taskId);
    }

    @MethodHelp(description="Aborts an active task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void abort(String taskId) {
        this.proxies.getTaskBlockRegistry().abort(taskId);
    }

    @MethodHelp(description="Cancels a stopped task.", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void cancel(String taskId) {
        this.proxies.getTaskBlockRegistry().cancel(taskId);
    }

    @MethodHelp(description="Archives an executed task.", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void archive(String taskId) {
        this.proxies.getTaskBlockRegistry().archive(taskId);
    }

    @MethodHelp(description="Skips steps of a task.", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="stepIds", description="The ids of the steps to skip.")}, returns="The updated task with block information.")
    public TaskWithBlock skip(String taskId, List<String> stepIds) {
        return this.proxies.getTaskBlockRegistry().skip(taskId, (List)Lists.newArrayList(stepIds));
    }

    @MethodHelp(description="Unskips steps of a task.", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="stepIds", description="The ids of the steps to skip.")}, returns="The updated task with block information.")
    public TaskWithBlock unskip(String taskId, List<String> stepIds) {
        return this.proxies.getTaskBlockRegistry().unskip(taskId, (List)Lists.newArrayList(stepIds));
    }

    @MethodHelp(description="Add a pause step to a task.", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="stepPath", description="The step path where the new pause step should appear.")}, returns="The step block containing the new pause step.")
    public StepBlockState addPause(String taskId, String stepPath) {
        return this.proxies.getTaskBlockRegistry().addPause(taskId, stepPath);
    }

    @MethodHelp(description="Assigns a pending task to another principal.", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="owner", description="The new task owner.")}, returns="The task without step information.")
    public TaskWithBlock assign(String taskId, String owner) {
        return this.proxies.getTaskBlockRegistry().assign(taskId, owner);
    }

    @MethodHelp(description="Takeover the ownership of a task from the current owner.", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="currentOwner", description="The current task owner.")}, returns="The task without step information.")
    public TaskWithBlock takeover(String taskId, String currentOwner) {
        return this.proxies.getTaskBlockRegistry().takeover(taskId, currentOwner);
    }

    @MethodHelp(description="Gets all task information from the repository's archive in the specified date range.", parameters={@ParameterHelp(name="beginDate", description="Begin date from which to return tasks in 'MM/dd/yyyy' format."), @ParameterHelp(name="endDate", description="End date from which to return tasks in 'MM/dd/yyyy' format.")}, returns="A list of tasks without step information.")
    public List<TaskWithBlock> query(String beginDate, String endDate) {
        return this.proxies.getTaskBlockRegistry().query(DateHelp.toLocalDate(beginDate), DateHelp.toLocalDate(endDate)).collect(Collectors.toList());
    }

    @MethodHelp(description="Gets all task information, including steps, from the repository's archive in the specified date range.", parameters={@ParameterHelp(name="beginDate", description="Begin date from which to return tasks in 'MM/dd/yyyy' format."), @ParameterHelp(name="endDate", description="End date from which to return tasks in 'MM/dd/yyyy' format.")}, returns="A list of tasks with their enclosed blocks and steps.")
    public List<TaskWithBlock> export(String beginDate, String endDate) {
        return this.proxies.getTaskBlockRegistry().export(DateHelp.toLocalDate(beginDate), DateHelp.toLocalDate(endDate)).collect(Collectors.toList());
    }
}

