/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.status;

import java.nio.charset.StandardCharsets;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public class PerImageIndicator {
    public static final int PER_IMAGE_TYPE_ID = 10;

    public static AtomicCounter allocate(String name, CountersManager countersManager, long registrationId, int sessionId, int streamId, String channel, String suffix) {
        String label = name + ": " + registrationId + ' ' + sessionId + ' ' + streamId + ' ' + channel + ' ' + suffix;
        return countersManager.newCounter(label, 10, buffer -> {
            buffer.putLong(0, registrationId);
            buffer.putInt(8, sessionId);
            buffer.putInt(12, streamId);
            byte[] channelBytes = channel.getBytes(StandardCharsets.UTF_8);
            int length = Math.min(channelBytes.length, 100);
            buffer.putInt(16, length);
            buffer.putBytes(20, channelBytes, 0, length);
        });
    }
}

