/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import com.xebialabs.deployit.ServerState;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class MaintenanceModeFilter
implements Filter {
    public static final String PARAMETER_MAINTENANCE_FORBIDDEN_REQUEST = "maintenance.forbidden_paths";
    public static final String PARAMETER_CONTEXT_ROOT = "maintenance.context_root";
    private static final Logger logger = LoggerFactory.getLogger(MaintenanceModeFilter.class);
    private List<PathAndMethod> forbiddenPaths = new ArrayList<PathAndMethod>();

    public void init(FilterConfig filterConfig) throws ServletException {
        String contextRoot = filterConfig.getInitParameter(PARAMETER_CONTEXT_ROOT);
        if (!contextRoot.endsWith("/")) {
            contextRoot = contextRoot + "/";
        }
        String pathsParam = filterConfig.getInitParameter(PARAMETER_MAINTENANCE_FORBIDDEN_REQUEST);
        this.forbiddenPaths = PathAndMethod.fromRequestParam(contextRoot, pathsParam);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean inMaintenanceMode;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = httpRequest.getMethod();
        String requestUri = httpRequest.getRequestURI();
        ServerState serverState = ServerState.getInstance();
        boolean bl = inMaintenanceMode = ServerState.Mode.MAINTENANCE == serverState.getCurrentMode();
        if (inMaintenanceMode) {
            boolean hasAuthentication;
            logger.trace("Processing '{}' request for '{}' in MAINTENANCE mode.", (Object)method, (Object)requestUri);
            Authentication authentication = Permissions.getAuthentication();
            boolean bl2 = hasAuthentication = null != authentication;
            if (hasAuthentication && !PermissionHelper.isCurrentUserAdmin() && this.isForbiddenInMaintenanceMode(httpRequest)) {
                httpResponse.getWriter().write("Server is in MAINTENANCE mode (shutdown pending).");
                httpResponse.setStatus(503);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private boolean isForbiddenInMaintenanceMode(HttpServletRequest request) {
        boolean isRequestAllowed = false;
        String uri = request.getRequestURI();
        String method = request.getMethod();
        for (PathAndMethod pam : this.forbiddenPaths) {
            if (!pam.matches(uri, method)) continue;
            isRequestAllowed = true;
            break;
        }
        return isRequestAllowed;
    }

    static class PathAndMethod {
        private String path;
        private String method;

        private PathAndMethod() {
        }

        private PathAndMethod(String path, String method) {
            this.path = path;
            this.method = method;
        }

        public static PathAndMethod parse(String pathAndMethod) {
            String[] paths = pathAndMethod.split(":");
            if (paths.length == 2) {
                String p = paths[0];
                String m = paths[1];
                return new PathAndMethod(p, m);
            }
            return new PathAndMethod();
        }

        public static List<PathAndMethod> fromRequestParam(String contextRoot, String paths) {
            ArrayList<PathAndMethod> pathList = new ArrayList<PathAndMethod>();
            if (null != paths) {
                String[] pathAndMethodArray;
                for (String pathAndMethodValue : pathAndMethodArray = paths.split(",")) {
                    if ((pathAndMethodValue = pathAndMethodValue.trim()).length() <= 0) continue;
                    pathAndMethodValue = contextRoot + pathAndMethodValue;
                    PathAndMethod pathAndMethod = PathAndMethod.parse(pathAndMethodValue);
                    pathList.add(pathAndMethod);
                }
            }
            return pathList;
        }

        public boolean matches(String requestUri, String requestMethod) {
            boolean retval = false;
            if (null != this.method && null != this.path) {
                boolean methodMatches = "*".equals(this.method) || this.method.equals(requestMethod);
                boolean requestUriStartsWithPath = requestUri.startsWith(this.path);
                if (methodMatches && requestUriStartsWithPath) {
                    retval = true;
                }
            }
            return retval;
        }
    }
}

