/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.transport.tcp.async;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PacketBufferReader {
    private static final int NO_PACKET_LENGTH = -1;
    private static final int HEADER_SIZE = 4;
    private static final int READ_BUFFER_CAPACITY = 9000;
    private final ByteBuffer readBuffer = ByteBuffer.allocate(9000);
    private int currentPacketLength = -1;

    public PacketBufferReader() {
        this.readBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    public byte[] readNext() {
        this.readBuffer.flip();
        byte[] result = this.isAwaitingHeader() ? this.readPacketHeaderAndBody() : this.readPacketBody();
        this.readBuffer.compact();
        return result;
    }

    public ByteBuffer getBuffer() {
        return this.readBuffer;
    }

    private boolean isAwaitingHeader() {
        return this.currentPacketLength == -1;
    }

    private byte[] readPacketHeaderAndBody() {
        if (!this.ensureBytesAvailable(4)) {
            return null;
        }
        this.currentPacketLength = this.readBuffer.getInt() & 0xFFFFFF;
        return this.readPacketBody();
    }

    private byte[] readPacketBody() {
        if (!this.ensureBytesAvailable(this.currentPacketLength)) {
            return null;
        }
        byte[] buf = new byte[this.currentPacketLength];
        this.readBuffer.get(buf);
        this.currentPacketLength = -1;
        return buf;
    }

    private boolean ensureBytesAvailable(int bytesNeeded) {
        return this.readBuffer.remaining() >= bytesNeeded;
    }
}

