/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.provision.repository;

import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.provision.repository.ReferenceService;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.JcrPathHelper;
import java.io.Serializable;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;

public final class JcrReferenceService$
implements ReferenceService {
    public static JcrReferenceService$ MODULE$;
    private final String QUERY_PREFIX;

    static {
        new JcrReferenceService$();
    }

    private String QUERY_PREFIX() {
        return this.QUERY_PREFIX;
    }

    @Override
    public Map<String, List<String>> findNodeReferences(ChangeSet changeSet) {
        return (Map)JcrTemplateHolder.get().execute(session -> MODULE$.findNodeRefs(changeSet, session));
    }

    private Map<String, List<String>> findNodeRefs(ChangeSet changeSet, Session session) {
        return ((TraversableOnce)((TraversableLike)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(changeSet.getDeleteCiIds()).filter((Function1 & Serializable & scala.Serializable)deleteNodeId -> BoxesRunTime.boxToBoolean((boolean)JcrReferenceService$.nodeExists$1(deleteNodeId, session)))).flatMap((Function1 & Serializable & scala.Serializable)deleteNodeId -> {
            Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId((String)deleteNodeId));
            Map<String, List<String>> deletedEntityRefs = MODULE$.collect(node.getReferences(), node, (String)deleteNodeId, MODULE$.collect$default$4());
            List<Node> nodes = MODULE$.findNodesByParent((String)deleteNodeId, session);
            return MODULE$.addChildrenNodesToDeletedEntityRefs(ImplicitConversions$.MODULE$.seq$u0020AsJavaList(nodes).iterator(), (String)deleteNodeId, deletedEntityRefs);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, List<String>> collect(PropertyIterator references, Node node, String deleteNodeId, Map<String, List<String>> deletedEntityRefs) {
        while (references.hasNext()) {
            Property property = references.nextProperty();
            if (this.isParentListCiReference(property, node)) continue;
            String string = property.getName();
            String string2 = "members";
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            Option option = deletedEntityRefs.get((Object)deleteNodeId);
            if (option instanceof Some) {
                Some some = (Some)option;
                List list = (List)some.value();
                Tuple2[] tuple2Array = new Tuple2[1];
                String string3 = property.getParent().getPath();
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deleteNodeId), list.$plus$colon((Object)string3, List$.MODULE$.canBuildFrom()));
                deletedEntityRefs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                deletedEntityRefs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deleteNodeId), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{property.getParent().getPath()})))}));
                continue;
            }
            throw new MatchError((Object)option);
        }
        return deletedEntityRefs;
    }

    private Map<String, List<String>> collect$default$4() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Map<String, List<String>> addChildrenNodesToDeletedEntityRefs(Iterator<Node> iterator, String deleteNodeId, Map<String, List<String>> deletedEntityRefs) {
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Option option = deletedEntityRefs.get((Object)deleteNodeId);
            if (option instanceof Some) {
                Some some = (Some)option;
                List list = (List)some.value();
                Tuple2[] tuple2Array = new Tuple2[1];
                String string = node.getPath();
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deleteNodeId), list.$plus$colon((Object)string, List$.MODULE$.canBuildFrom()));
                deletedEntityRefs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                deletedEntityRefs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deleteNodeId), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{node.getPath()})))}));
                continue;
            }
            throw new MatchError((Object)option);
        }
        return deletedEntityRefs;
    }

    private Map<String, List<String>> addChildrenNodesToDeletedEntityRefs$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private List<Node> findNodesByParent(String deleteNodeId, Session session) {
        List<Node> list;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(this.QUERY_PREFIX() + " WHERE ISDESCENDANTNODE(ci,'/" + deleteNodeId + "')", "JCR-SQL2");
            NodeIterator nodes = query.execute().getNodes();
            list = this.collectNodes(nodes, this.collectNodes$default$2());
        }
        catch (RepositoryException ex) {
            throw new RuntimeRepositoryException("Exception Occured while executing the Query", ex);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Exception Occured while executing the Query", ex);
        }
        return list;
    }

    private List<Node> collectNodes(NodeIterator nodes, List<Node> nodeList) {
        NodeIterator nodeIterator;
        while ((nodeIterator = nodes).hasNext()) {
            nodeList = (List)nodeList.$colon$plus((Object)nodeIterator.nextNode(), List$.MODULE$.canBuildFrom());
            nodes = nodeIterator;
        }
        List list = nodeList;
        return list;
    }

    private List<Node> collectNodes$default$2() {
        return Nil$.MODULE$;
    }

    private boolean isParentListCiReference(Property referenceProperty, Node nodeToBeDeleted) throws RepositoryException {
        String string = nodeToBeDeleted.getParent().getPath();
        String string2 = referenceProperty.getParent().getPath();
        return (string == null ? string2 != null : !string.equals(string2)) ? false : this.descriptorOf(referenceProperty).isAsContainment() && this.descriptorOf(referenceProperty).getKind() == PropertyKind.LIST_OF_CI;
    }

    public Type typeOf(Node node) throws RepositoryException {
        return Type.valueOf((String)node.getProperty("$configuration.item.type").getString());
    }

    public PropertyDescriptor descriptorOf(Property property) throws RepositoryException {
        return this.typeOf(property.getParent()).getDescriptor().getPropertyDescriptor(property.getName());
    }

    private static final boolean nodeExists$1(String deleteNodeId, Session session) {
        return session.nodeExists(JcrPathHelper.getAbsolutePathFromId((String)deleteNodeId));
    }

    private JcrReferenceService$() {
        MODULE$ = this;
        this.QUERY_PREFIX = "SELECT ci.* FROM [deployit:configurationItem] AS ci";
    }
}

