/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import io.aeron.driver.SubscriberPosition;
import java.nio.ByteBuffer;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastTransmitter;

public class ClientProxy {
    private static final int WRITE_BUFFER_CAPACITY = 4096;
    private final UnsafeBuffer buffer = new UnsafeBuffer(ByteBuffer.allocateDirect(4096));
    private final BroadcastTransmitter transmitter;
    private final ErrorResponseFlyweight errorResponse = new ErrorResponseFlyweight();
    private final PublicationBuffersReadyFlyweight publicationReady = new PublicationBuffersReadyFlyweight();
    private final ImageBuffersReadyFlyweight imageReady = new ImageBuffersReadyFlyweight();
    private final CorrelatedMessageFlyweight correlatedMessage = new CorrelatedMessageFlyweight();
    private final ImageMessageFlyweight imageMessage = new ImageMessageFlyweight();

    public ClientProxy(BroadcastTransmitter transmitter) {
        this.transmitter = transmitter;
        this.errorResponse.wrap((MutableDirectBuffer)this.buffer, 0);
        this.imageReady.wrap((MutableDirectBuffer)this.buffer, 0);
        this.publicationReady.wrap((MutableDirectBuffer)this.buffer, 0);
        this.correlatedMessage.wrap((MutableDirectBuffer)this.buffer, 0);
        this.imageMessage.wrap((MutableDirectBuffer)this.buffer, 0);
    }

    public void onError(ErrorCode errorCode, String errorMessage, long correlationId) {
        String msg = null == errorMessage ? "" : errorMessage;
        this.errorResponse.offendingCommandCorrelationId(correlationId).errorCode(errorCode).errorMessage(msg);
        this.transmit(3841, (DirectBuffer)this.buffer, 0, this.errorResponse.length());
    }

    public void onAvailableImage(long correlationId, int streamId, int sessionId, String logFileName, List<SubscriberPosition> subscriberPositions, String sourceIdentity) {
        this.imageReady.sessionId(sessionId).streamId(streamId).correlationId(correlationId);
        int size = subscriberPositions.size();
        this.imageReady.subscriberPositionCount(size);
        for (int i = 0; i < size; ++i) {
            SubscriberPosition position = subscriberPositions.get(i);
            this.imageReady.subscriberPositionId(i, position.positionCounterId());
            this.imageReady.positionIndicatorRegistrationId(i, position.subscription().registrationId());
        }
        this.imageReady.logFileName(logFileName).sourceIdentity(sourceIdentity);
        int length = this.imageReady.length();
        this.transmit(3842, (DirectBuffer)this.buffer, 0, length);
    }

    public void onPublicationReady(long registrationId, int streamId, int sessionId, String logFileName, int positionCounterId, boolean isExclusive) {
        this.publicationReady.sessionId(sessionId).streamId(streamId).correlationId(registrationId).publicationLimitCounterId(positionCounterId).logFileName(logFileName);
        int length = this.publicationReady.length();
        int msgTypeId = isExclusive ? 3846 : 3843;
        this.transmit(msgTypeId, (DirectBuffer)this.buffer, 0, length);
    }

    public void operationSucceeded(long correlationId) {
        this.correlatedMessage.clientId(0L).correlationId(correlationId);
        this.transmit(3844, (DirectBuffer)this.buffer, 0, 16);
    }

    public void onUnavailableImage(long correlationId, int streamId, String channel) {
        this.imageMessage.correlationId(correlationId).streamId(streamId).channel(channel);
        int length = this.imageMessage.length();
        this.transmit(3845, (DirectBuffer)this.buffer, 0, length);
    }

    private void transmit(int msgTypeId, DirectBuffer buffer, int index, int length) {
        this.transmitter.transmit(msgTypeId, buffer, index, length);
    }
}

