/*
 * Decompiled with CFR 0.152.
 */
package com.tqdev.metrics.http;

import com.tqdev.metrics.core.MetricRegistry;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class MeasureRequestPathFilter
implements Filter {
    private final MetricRegistry registry;
    private String contentTypes;

    public MeasureRequestPathFilter() {
        this(MetricRegistry.getInstance(), null);
    }

    public MeasureRequestPathFilter(MetricRegistry registry, String contentTypes) {
        this.registry = registry;
        this.contentTypes = contentTypes;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.contentTypes == null) {
            this.contentTypes = filterConfig.getInitParameter("contentTypes");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.registry.isEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestURI = httpRequest.getRequestURI();
        long startTime = this.registry.getNanos();
        try {
            chain.doFilter(request, response);
        }
        finally {
            long duration = this.registry.getNanos() - startTime;
            this.registerMeasurement(requestURI, response.getContentType(), duration);
        }
    }

    private void registerMeasurement(String requestURI, String contentType, long duration) {
        String pathGroup = this.getPathGroup(requestURI, contentType);
        if (pathGroup != null) {
            this.registry.increment("http.Path.Invocations", pathGroup);
            this.registry.add("http.Path.Durations", pathGroup, duration);
        }
    }

    private String getPathGroup(String requestURI, String contentType) {
        if (requestURI == null || contentType == null || !contentType.matches(".*(" + this.contentTypes + ").*")) {
            return "(other)";
        }
        CharSequence[] parts = requestURI.split("/");
        int i = 0;
        while (i < parts.length) {
            if (((String)parts[i]).matches("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}")) {
                parts[i] = "(uuid)";
            } else if (((String)parts[i]).matches("[a-f0-9]{128}")) {
                parts[i] = "(sha512)";
            } else if (((String)parts[i]).matches("[a-f0-9]{64}")) {
                parts[i] = "(sha256)";
            } else if (((String)parts[i]).matches("[a-f0-9]{40}")) {
                parts[i] = "(sha1)";
            } else if (((String)parts[i]).matches("[a-f0-9]{32}")) {
                parts[i] = "(md5)";
            } else if (((String)parts[i]).matches("[^a-zA-Z]+") && ((String)parts[i]).matches(".*[0-9].*")) {
                parts[i] = "(number)";
            }
            ++i;
        }
        String path = String.join((CharSequence)"/", parts);
        if (path.isEmpty()) {
            path = "/";
        }
        return path;
    }
}

