/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.PublicationImage;
import io.aeron.driver.Receiver;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.cmd.AddSubscriptionCmd;
import io.aeron.driver.cmd.CloseReceiveChannelEndpointCmd;
import io.aeron.driver.cmd.NewPublicationImageCmd;
import io.aeron.driver.cmd.ReceiverCmd;
import io.aeron.driver.cmd.RegisterReceiveChannelEndpointCmd;
import io.aeron.driver.cmd.RemoveCoolDownCmd;
import io.aeron.driver.cmd.RemoveSubscriptionCmd;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import java.util.Queue;
import org.agrona.concurrent.status.AtomicCounter;

public class ReceiverProxy {
    private final ThreadingMode threadingMode;
    private final Queue<ReceiverCmd> commandQueue;
    private final AtomicCounter failCount;
    private Receiver receiver;

    public ReceiverProxy(ThreadingMode threadingMode, Queue<ReceiverCmd> commandQueue, AtomicCounter failCount) {
        this.threadingMode = threadingMode;
        this.commandQueue = commandQueue;
        this.failCount = failCount;
    }

    public void receiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public Receiver receiver() {
        return this.receiver;
    }

    public void addSubscription(ReceiveChannelEndpoint mediaEndpoint, int streamId) {
        if (this.isSharedThread()) {
            this.receiver.onAddSubscription(mediaEndpoint, streamId);
        } else {
            this.offer(new AddSubscriptionCmd(mediaEndpoint, streamId));
        }
    }

    public void removeSubscription(ReceiveChannelEndpoint mediaEndpoint, int streamId) {
        if (this.isSharedThread()) {
            this.receiver.onRemoveSubscription(mediaEndpoint, streamId);
        } else {
            this.offer(new RemoveSubscriptionCmd(mediaEndpoint, streamId));
        }
    }

    public void newPublicationImage(ReceiveChannelEndpoint channelEndpoint, PublicationImage image) {
        if (this.isSharedThread()) {
            this.receiver.onNewPublicationImage(channelEndpoint, image);
        } else {
            this.offer(new NewPublicationImageCmd(channelEndpoint, image));
        }
    }

    public void registerReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        if (this.isSharedThread()) {
            this.receiver.onRegisterReceiveChannelEndpoint(channelEndpoint);
        } else {
            this.offer(new RegisterReceiveChannelEndpointCmd(channelEndpoint));
        }
    }

    public void closeReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        if (this.isSharedThread()) {
            this.receiver.onCloseReceiveChannelEndpoint(channelEndpoint);
        } else {
            this.offer(new CloseReceiveChannelEndpointCmd(channelEndpoint));
        }
    }

    public void removeCoolDown(ReceiveChannelEndpoint channelEndpoint, int sessionId, int streamId) {
        if (this.isSharedThread()) {
            this.receiver.onRemoveCoolDown(channelEndpoint, sessionId, streamId);
        } else {
            this.offer(new RemoveCoolDownCmd(channelEndpoint, sessionId, streamId));
        }
    }

    private boolean isSharedThread() {
        return this.threadingMode == ThreadingMode.SHARED;
    }

    private void offer(ReceiverCmd cmd) {
        while (!this.commandQueue.offer(cmd)) {
            this.failCount.orderedIncrement();
            Thread.yield();
        }
    }
}

