/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.NanoClock;

public class UdpDestinationTracker {
    private final ArrayList<Destination> destinationList = new ArrayList();
    private final NanoClock nanoClock;
    private final PreSendFunction preSendFunction;
    private final long destinationTimeout;

    public UdpDestinationTracker(NanoClock nanoClock, PreSendFunction preSendFunction, long timeout) {
        this.nanoClock = nanoClock;
        this.preSendFunction = preSendFunction;
        this.destinationTimeout = timeout;
    }

    public UdpDestinationTracker(PreSendFunction preSendFunction) {
        this.nanoClock = () -> 0L;
        this.preSendFunction = preSendFunction;
        this.destinationTimeout = 0L;
    }

    public int sendToDestinations(DatagramChannel sendDatagramChannel, ByteBuffer buffer) {
        int lastIndex;
        ArrayList<Destination> destinationList = this.destinationList;
        long now = this.nanoClock.nanoTime();
        int minByteSent = buffer.remaining();
        for (int i = lastIndex = destinationList.size() - 1; i >= 0; --i) {
            Destination destination = destinationList.get(i);
            if (now > destination.timeOfLastActivity + this.destinationTimeout) {
                ArrayListUtil.fastUnorderedRemove(destinationList, (int)i, (int)lastIndex);
                --lastIndex;
                continue;
            }
            int byteSent = 0;
            try {
                this.preSendFunction.presend(buffer, destination.address);
                int position = buffer.position();
                byteSent = sendDatagramChannel.send(buffer, destination.address);
                buffer.position(position);
            }
            catch (PortUnreachableException | ClosedChannelException position) {
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
            minByteSent = Math.min(minByteSent, byteSent);
        }
        return minByteSent;
    }

    public void destinationActivity(long receiverId, InetSocketAddress destAddress) {
        if (this.destinationTimeout > 0L) {
            ArrayList<Destination> destinationList = this.destinationList;
            long now = this.nanoClock.nanoTime();
            boolean isExisting = false;
            int size = destinationList.size();
            for (int i = 0; i < size; ++i) {
                Destination destination = destinationList.get(i);
                if (receiverId != destination.receiverId || destAddress.getPort() != destination.port) continue;
                destination.timeOfLastActivity = now;
                isExisting = true;
                break;
            }
            if (!isExisting) {
                destinationList.add(new Destination(now, receiverId, destAddress));
            }
        }
    }

    public boolean isManualControlMode() {
        return this.destinationTimeout == 0L;
    }

    public void addDestination(InetSocketAddress address) {
        this.destinationList.add(new Destination(Long.MAX_VALUE, 0L, address));
    }

    public void removeDestination(InetSocketAddress address) {
        int lastIndex;
        ArrayList<Destination> destinationList = this.destinationList;
        for (int i = lastIndex = destinationList.size() - 1; i >= 0; --i) {
            Destination destination = destinationList.get(i);
            if (!address.equals(destination.address)) continue;
            ArrayListUtil.fastUnorderedRemove(destinationList, (int)i, (int)lastIndex);
            break;
        }
    }

    public static class Destination {
        long timeOfLastActivity;
        long receiverId;
        int port;
        InetSocketAddress address;

        Destination(long now, long receiverId, InetSocketAddress address) {
            this.timeOfLastActivity = now;
            this.receiverId = receiverId;
            this.address = address;
            this.port = address.getPort();
        }
    }

    public static interface PreSendFunction {
        public void presend(ByteBuffer var1, InetSocketAddress var2);
    }
}

