/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.SortComparator;

class SharedFieldCache {
    public static final SharedFieldCache INSTANCE = new SharedFieldCache();
    private final Map cache = new WeakHashMap();

    private SharedFieldCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringIndex getStringIndex(IndexReader reader, String field, String prefix, SortComparator comparator, boolean includeLookup) throws IOException {
        StringIndex ret;
        if (reader instanceof ReadOnlyIndexReader) {
            reader = ((ReadOnlyIndexReader)reader).getBase();
        }
        if ((ret = this.lookup((IndexReader)reader, field = field.intern(), prefix, comparator)) == null) {
            String[] retArray = new String[reader.maxDoc()];
            ArrayList<String> mterms = null;
            if (includeLookup) {
                mterms = new ArrayList<String>();
            }
            int setValues = 0;
            if (retArray.length > 0) {
                TermDocs termDocs = reader.termDocs();
                TermEnum termEnum = reader.terms(new Term(field, prefix));
                if (includeLookup) {
                    mterms.add(null);
                }
                try {
                    Term term;
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + field);
                    }
                    while ((term = termEnum.term()).field() == field) {
                        if (!term.text().startsWith(prefix)) {
                        } else {
                            if (includeLookup) {
                                mterms.add(term.text().substring(prefix.length()));
                            }
                            termDocs.seek(termEnum);
                            while (termDocs.next()) {
                                ++setValues;
                                retArray[termDocs.doc()] = term.text().substring(prefix.length());
                            }
                            if (termEnum.next()) continue;
                        }
                        break;
                    }
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            String[] lookup = null;
            if (includeLookup) {
                lookup = mterms.toArray(new String[mterms.size()]);
            }
            StringIndex value = new StringIndex(retArray, lookup, setValues);
            this.store((IndexReader)reader, field, prefix, comparator, value);
            return value;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringIndex lookup(IndexReader reader, String field, String prefix, SortComparator comparer) {
        Key key = new Key(field, prefix, comparer);
        SharedFieldCache sharedFieldCache = this;
        synchronized (sharedFieldCache) {
            HashMap readerCache = (HashMap)this.cache.get(reader);
            if (readerCache == null) {
                return null;
            }
            return (StringIndex)readerCache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object store(IndexReader reader, String field, String prefix, SortComparator comparer, StringIndex value) {
        Key key = new Key(field, prefix, comparer);
        SharedFieldCache sharedFieldCache = this;
        synchronized (sharedFieldCache) {
            HashMap<Key, StringIndex> readerCache = (HashMap<Key, StringIndex>)this.cache.get(reader);
            if (readerCache == null) {
                readerCache = new HashMap<Key, StringIndex>();
                this.cache.put(reader, readerCache);
            }
            return readerCache.put(key, value);
        }
    }

    static class Key {
        private final String field;
        private final String prefix;
        private final SortComparator comparator;

        Key(String field, String prefix, SortComparator comparator) {
            this.field = field.intern();
            this.prefix = prefix.intern();
            this.comparator = comparator;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return other.field == this.field && other.prefix == this.prefix && other.comparator.equals(this.comparator);
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.prefix.hashCode() ^ this.comparator.hashCode();
        }
    }

    public static class StringIndex {
        private static final int SPARSE_FACTOR = 100;
        public final String[] lookup;
        private final String[] terms;
        public final Map termsMap;
        public final boolean sparse;

        public StringIndex(String[] terms, String[] lookup, int setValues) {
            if (this.isSparse(terms, setValues)) {
                this.sparse = true;
                this.terms = null;
                this.termsMap = setValues == 0 ? null : this.getTermsMap(terms, setValues);
            } else {
                this.sparse = false;
                this.terms = terms;
                this.termsMap = null;
            }
            this.lookup = lookup;
        }

        public String getTerm(int i) {
            if (this.sparse) {
                return this.termsMap == null ? null : (String)this.termsMap.get(new Integer(i));
            }
            return this.terms[i];
        }

        private Map getTermsMap(String[] terms, int setValues) {
            HashMap<Integer, String> map = new HashMap<Integer, String>(setValues);
            for (int i = 0; i < terms.length && setValues > 0; ++i) {
                if (terms[i] == null) continue;
                map.put(new Integer(i), terms[i]);
                --setValues;
            }
            return map;
        }

        private boolean isSparse(String[] terms, int setValues) {
            return setValues * 100 < terms.length;
        }
    }
}

