/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.util.logging.Logger;

abstract class FileSystemAction {
    private static final Logger log = Logger.getLogger(FileSystemAction.class.getName());

    FileSystemAction() {
    }

    private static FileSystemAction decode(String line) {
        if (line == null) {
            throw new NullPointerException();
        }
        if (line.length() == 0) {
            throw new IllegalArgumentException("Line has length zero");
        }
        char t = line.charAt(0);
        if (t == 'C' || t == 'D') {
            int length;
            int endLength = line.indexOf(32, 6);
            if (endLength == -1) {
                throw new IllegalArgumentException();
            }
            String s = line.substring(6, endLength);
            if (s.length() == 1 && s.charAt(0) == '0') {
                length = 0;
            } else {
                try {
                    length = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse file length " + s);
                }
            }
            String name = line.substring(endLength + 1);
            if (t == 'D') {
                return new StartDirectory(name);
            }
            return new File(name, length);
        }
        if (t == 'E') {
            return new EndDirectory();
        }
        throw new IllegalArgumentException("Could not recognize file system action " + line);
    }

    private static class EndDirectory
    extends FileSystemAction {
        private EndDirectory() {
        }

        public String toString() {
            return "EndDirectory[]";
        }
    }

    private static class File
    extends FileSystemAction {
        private final String name;
        private final int length;

        private File(String name, int length) {
            this.name = name;
            this.length = length;
        }

        public String toString() {
            return "File[name=" + this.name + ",length=" + this.length + "]";
        }
    }

    private static class StartDirectory
    extends FileSystemAction {
        private final String name;

        private StartDirectory(String name) {
            this.name = name;
        }

        public String toString() {
            return "StartDirectory[name=" + this.name + "]";
        }
    }
}

