/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdfsc;

import com.hierynomus.msdfsc.DFSPath;
import com.hierynomus.msdfsc.messages.DFSReferral;
import com.hierynomus.msdfsc.messages.SMB2GetDFSReferralResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ReferralCache {
    private ConcurrentHashMap<String, ReferralCacheEntry> cache = new ConcurrentHashMap();

    public ReferralCacheEntry lookup(DFSPath dfsPath) {
        return null;
    }

    public void put(ReferralCacheEntry referralCacheEntry) {
        this.cache.put(referralCacheEntry.dfsPathPrefix, referralCacheEntry);
    }

    public void clear() {
        this.cache.clear();
    }

    public static class ReferralCacheEntry {
        String dfsPathPrefix;
        DFSReferral.ServerType rootOrLink;
        boolean interlink;
        int ttl;
        long expires;
        boolean targetFailback;
        TargetSetEntry targetHint;
        List<TargetSetEntry> targetList;

        public ReferralCacheEntry(SMB2GetDFSReferralResponse response) {
            List<DFSReferral> referralEntries = response.getReferralEntries();
            for (int i = 0; i < referralEntries.size(); ++i) {
                if (referralEntries.get(i).getPath() != null) continue;
                throw new IllegalStateException("Path cannot be null for a ReferralCacheEntry?");
            }
            DFSReferral firstReferral = referralEntries.get(0);
            this.dfsPathPrefix = firstReferral.getDfsPath();
            this.rootOrLink = firstReferral.getServerType();
            boolean bl = this.interlink = response.getReferralHeaderFlags().contains(SMB2GetDFSReferralResponse.ReferralHeaderFlags.ReferralServers) && !response.getReferralHeaderFlags().contains(SMB2GetDFSReferralResponse.ReferralHeaderFlags.StorageServers);
            if (!this.interlink && referralEntries.size() == 1) {
                this.interlink = true;
            }
            this.ttl = firstReferral.getTtl();
            this.expires = System.currentTimeMillis() + (long)this.ttl * 1000L;
            this.targetFailback = response.getReferralHeaderFlags().contains(SMB2GetDFSReferralResponse.ReferralHeaderFlags.TargetFailback);
            this.targetList = new ArrayList<TargetSetEntry>(referralEntries.size());
            for (DFSReferral r : referralEntries) {
                TargetSetEntry e = new TargetSetEntry();
                e.targetPath = r.getPath();
                this.targetList.add(e);
            }
            this.targetHint = this.targetList.get(0);
        }

        public boolean isExpired() {
            long now = System.currentTimeMillis();
            return now < this.expires;
        }

        public boolean isLink() {
            return this.rootOrLink == DFSReferral.ServerType.LINK;
        }

        public boolean isRoot() {
            return this.rootOrLink == DFSReferral.ServerType.ROOT;
        }

        public boolean isInterlink() {
            return this.isLink() && this.interlink;
        }

        public String getDfsPathPrefix() {
            return this.dfsPathPrefix;
        }

        public TargetSetEntry getTargetHint() {
            return this.targetHint;
        }

        public List<TargetSetEntry> getTargetList() {
            return this.targetList;
        }

        public String toString() {
            return this.dfsPathPrefix + "->" + this.targetHint.targetPath + ", " + this.targetList;
        }
    }

    public static class TargetSetEntry {
        String targetPath;
        boolean targetSetBoundary;

        public String getTargetPath() {
            return this.targetPath;
        }
    }
}

