/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.booter.remote.RemoteDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@XStreamProvider(tagName="descriptor", readable=Descriptor.class)
public class DescriptorConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        throw new IllegalStateException("Cannot serialize Descriptors from remote-booter");
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String booterConfigKey = (String)context.get((Object)"BOOTER_CONFIG");
        DeployitCommunicator communicator = RemoteBooter.getCommunicator(booterConfigKey);
        RemoteDescriptor descriptor = new RemoteDescriptor();
        this.setAttributes(reader, descriptor, communicator);
        while (reader.hasMoreChildren()) {
            List list;
            reader.moveDown();
            if ("description".equals(reader.getNodeName())) {
                descriptor.setDescription(reader.getValue());
            } else if ("icon".equals(reader.getNodeName())) {
                String icon = reader.getValue();
                descriptor.setIcon(icon);
            } else if ("property-descriptors".equals(reader.getNodeName())) {
                list = Converters.readList((Object)descriptor, PropertyDescriptor.class, (HierarchicalStreamReader)reader, (UnmarshallingContext)context);
                descriptor.setPropertyDescriptors(list);
            } else if ("control-tasks".equals(reader.getNodeName())) {
                list = Converters.readList((Object)descriptor, MethodDescriptor.class, (HierarchicalStreamReader)reader, (UnmarshallingContext)context);
                descriptor.setControlTasks(list);
            } else if ("interfaces".equals(reader.getNodeName())) {
                HashSet<Type> interfaces = new HashSet<Type>();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    interfaces.add(Type.valueOf((String)reader.getValue()));
                    reader.moveUp();
                }
                descriptor.setInterfaces(interfaces);
            } else if ("superTypes".equals(reader.getNodeName())) {
                ArrayList<Type> superTypes = new ArrayList<Type>();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    superTypes.add(Type.valueOf((String)reader.getValue()));
                    reader.moveUp();
                }
                descriptor.setSuperTypes(superTypes);
            }
            reader.moveUp();
        }
        return descriptor;
    }

    private void setAttributes(HierarchicalStreamReader reader, RemoteDescriptor descriptor, DeployitCommunicator communicator) {
        String inspectable;
        String versioned;
        String virtual;
        String containerType;
        descriptor.setType(communicator.getType(reader.getAttribute("type")));
        descriptor.setLabel(reader.getAttribute("label"));
        String deployableType = reader.getAttribute("deployableType");
        if (deployableType != null) {
            descriptor.setDeployableType(communicator.getType(deployableType));
        }
        if ((containerType = reader.getAttribute("containerType")) != null) {
            descriptor.setContainerType(communicator.getType(containerType));
        }
        if ("true".equalsIgnoreCase(virtual = reader.getAttribute("virtual"))) {
            descriptor.setVirtual();
        }
        if ("false".equalsIgnoreCase(versioned = reader.getAttribute("versioned"))) {
            descriptor.setVersioned(false);
        }
        if ("true".equalsIgnoreCase(inspectable = reader.getAttribute("inspectable"))) {
            descriptor.setInspectable();
        }
        descriptor.setRootName(this.readRoot(reader));
    }

    private String readRoot(HierarchicalStreamReader reader) {
        return reader.getAttribute("root");
    }

    public boolean canConvert(Class type) {
        return type.equals(Descriptor.class);
    }
}

