/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit371GlobalToLocalPermissions
extends JcrUpgrade {
    private static final List<String> TO_BE_CONVERTED = Lists.newArrayList((Object[])new String[]{DeployitPermissions.TASK_SKIPSTEP.getPermissionName(), DeployitPermissions.TASK_MOVESTEP.getPermissionName()});
    private static final Logger logger = LoggerFactory.getLogger(Deployit371GlobalToLocalPermissions.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting Deployit 3.7.1 upgrade -- Global to Local permissions ***");
        Node securityNode = repository.read("/$configuration/security");
        try {
            Map<String, String> permissionToRoleIds = this.readGlobalPermissions(securityNode);
            logger.debug("Found global permissions: {}", permissionToRoleIds);
            this.convertPermissions(repository, permissionToRoleIds);
            this.writeNewGlobalPermissions(securityNode, permissionToRoleIds);
        }
        catch (RepositoryException e) {
            throw new UpgradeException("Could not convert global to local permissions", (Exception)((Object)e));
        }
        logger.info("*** Done Deployit 3.7.1 upgrade -- Global to Local permissions ***");
        return true;
    }

    private void convertPermissions(RawRepository repository, Map<String, String> permissionToRoleIds) throws RepositoryException {
        Map toBeConverted = Maps.filterKeys(permissionToRoleIds, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return TO_BE_CONVERTED.contains(input);
            }
        });
        logger.debug("Going to write these permissions under the local nodes: {}", (Object)toBeConverted);
        Node environments = repository.read(JcrPathHelper.getAbsolutePathFromId((String)Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()));
        this.updateNode(environments, toBeConverted);
        List directories = repository.findNodesByType(Type.valueOf(Directory.class));
        logger.debug("Found these directories {}", (Object)directories);
        for (Node directory : directories) {
            this.updateNode(directory, toBeConverted);
        }
    }

    private void updateNode(Node node, Map<String, String> toBeConverted) throws RepositoryException {
        if (node.hasProperty("securityPermissions") && DeployitPermissions.TASK_MOVESTEP.isApplicableTo(JcrPathHelper.getIdFromAbsolutePath((String)node.getPath()))) {
            logger.debug("Writing new local permissions on node [{}]", (Object)node.getPath());
            Map map = JcrUtils.readMap((Property)node.getProperty("securityPermissions"));
            logger.debug("read permissions {}", (Object)map);
            for (String k : toBeConverted.keySet()) {
                if (map.containsKey(k)) {
                    map.put(k, Joiner.on((String)",").join(map.get(k), (Object)toBeConverted.get(k), new Object[0]));
                    continue;
                }
                map.put(k, toBeConverted.get(k));
            }
            logger.debug("Going to write permissions {}", (Object)map);
            JcrUtils.writeMap((Node)node, (String)"securityPermissions", (Map)map);
        }
    }

    private void writeNewGlobalPermissions(Node securityNode, Map<String, String> permissionToRoleIds) throws RepositoryException {
        Map keepGlobal = Maps.filterKeys(permissionToRoleIds, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !TO_BE_CONVERTED.contains(input);
            }
        });
        JcrUtils.writeMap((Node)securityNode, (String)"securityPermissions", (Map)keepGlobal);
    }

    private Map<String, String> readGlobalPermissions(Node securityNode) throws RepositoryException {
        Property property = securityNode.getProperty("securityPermissions");
        return JcrUtils.readMap((Property)property);
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.7.1");
    }
}

