/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.task.archive.DeploymentResult;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.analytics.StatusOverviewReportLine;
import java.util.Collection;
import org.joda.time.DateTime;

public class DeploymentsPercentageWidgetData
extends DashboardWidgetBase {
    public DeploymentsPercentageWidgetData(TaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(DateTime beginDate, DateTime endDate) {
        Collection searchResult = this.taskArchive.statusOverview(beginDate, endDate);
        return this.transformResult(searchResult);
    }

    private Report transformResult(Collection<StatusOverviewReportLine> searchResult) {
        Report report = new Report();
        if (searchResult.size() == 0) {
            return report;
        }
        ReportLine line = report.addLine();
        int total = searchResult.stream().filter(sr -> sr.executionState().equals(DeploymentResult.TOTAL.name())).map(StatusOverviewReportLine::amount).findFirst().orElse(0);
        line.addValue("noOfSuccessfulDeployments", (Object)searchResult.stream().filter(sr -> sr.executionState().equals(DeploymentResult.SUCCESS.name())).map(sr -> DeploymentsPercentageWidgetData.getFormattedPercentage(sr.amount(), total)).findFirst().orElse(ZERO));
        line.addValue("noOfAbortedDeployments", (Object)searchResult.stream().filter(sr -> sr.executionState().equals(DeploymentResult.ABORTED.name())).map(sr -> DeploymentsPercentageWidgetData.getFormattedPercentage(sr.amount(), total)).findFirst().orElse(ZERO));
        line.addValue("noOfFailedDeployments", (Object)searchResult.stream().filter(sr -> sr.executionState().equals(DeploymentResult.FAILED.name())).map(sr -> DeploymentsPercentageWidgetData.getFormattedPercentage(sr.amount(), total)).findFirst().orElse(ZERO));
        line.addValue("noOfRollbacks", (Object)searchResult.stream().filter(sr -> sr.executionState().equals(DeploymentResult.ROLLBACK.name())).map(sr -> DeploymentsPercentageWidgetData.getFormattedPercentage(sr.amount(), total)).findFirst().orElse(ZERO));
        return report;
    }
}

