/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive.sql.reports;

import com.xebialabs.deployit.core.sql.OrderBy$;
import com.xebialabs.deployit.core.sql.SelectBuilder;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.DeploymentResult;
import com.xebialabs.deployit.task.archive.sql.reports.SqlDeploymentTaskAnalyticsQuery$;
import com.xebialabs.deployit.task.archive.sql.schema.ArchivedDeploymentTasks$;
import java.util.EnumSet;
import org.joda.time.DateTime;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u0001E\u0011qdU9m\t\u0016\u0004Hn\\=nK:$H+Y:l\u0003:\fG.\u001f;jGN\fV/\u001a:z\u0015\t\u0019A!A\u0004sKB|'\u000f^:\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\bCJ\u001c\u0007.\u001b<f\u0015\tI!\"\u0001\u0003uCN\\'BA\u0006\r\u0003!!W\r\u001d7ps&$(BA\u0007\u000f\u0003%AXMY5bY\u0006\u00147OC\u0001\u0010\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005)!-Z4j]B\u00111DI\u0007\u00029)\u0011QDH\u0001\u0005i&lWM\u0003\u0002 A\u0005!!n\u001c3b\u0015\u0005\t\u0013aA8sO&\u00111\u0005\b\u0002\t\t\u0006$X\rV5nK\"AQ\u0005\u0001B\u0001B\u0003%!$A\u0002f]\u0012D\u0001b\n\u0001\u0003\u0006\u0004%\u0019\u0001K\u0001\u000bgFdG)[1mK\u000e$X#A\u0015\u0011\u0005)rS\"A\u0016\u000b\u0005\u0015a#BA\u0017\u000b\u0003\u0011\u0019wN]3\n\u0005=Z#AC*rY\u0012K\u0017\r\\3di\"A\u0011\u0007\u0001B\u0001B\u0003%\u0011&A\u0006tc2$\u0015.\u00197fGR\u0004\u0003\"B\u001a\u0001\t\u0003!\u0014A\u0002\u001fj]&$h\bF\u00026si\"\"A\u000e\u001d\u0011\u0005]\u0002Q\"\u0001\u0002\t\u000b\u001d\u0012\u00049A\u0015\t\u000be\u0011\u0004\u0019\u0001\u000e\t\u000b\u0015\u0012\u0004\u0019\u0001\u000e\t\u000fq\u0002!\u0019!C\u0001{\u0005i1/\u001a7fGR\u0014U/\u001b7eKJ,\u0012A\u0010\t\u0003U}J!\u0001Q\u0016\u0003\u001bM+G.Z2u\u0005VLG\u000eZ3s\u0011\u0019\u0011\u0005\u0001)A\u0005}\u0005q1/\u001a7fGR\u0014U/\u001b7eKJ\u0004\u0003\"\u0002#\u0001\t\u0003)\u0015\u0001\b;ie>,x\r\u001b9vi\nKH)\u001a9m_flWM\u001c;SKN,H\u000e\u001e\u000b\u0003\r&\u0003\"aE$\n\u0005!#\"\u0001B+oSRDQAS\"A\u0002-\u000baa\u001d;biV\u001c\bC\u0001'N\u001b\u00051\u0011B\u0001(\u0007\u0005A!U\r\u001d7ps6,g\u000e\u001e*fgVdG\u000fC\u0003Q\u0001\u0011\u0005\u0011+A\fd_VtGOQ=EKBdw._7f]R\u0014Vm];miR\u0011aI\u0015\u0005\u0006\u0015>\u0003\ra\u0013\u0005\u0006)\u0002!\t!V\u0001\u0012i>$\u0018\r\\:Cs\u0006\u0003\b/\u00118e\u000b:4Hc\u0001$WG\")qk\u0015a\u00011\u0006y\u0011\r\u001d9mS\u000e\fG/[8o\u001d\u0006lW\r\u0005\u0002ZA:\u0011!L\u0018\t\u00037Ri\u0011\u0001\u0018\u0006\u0003;B\ta\u0001\u0010:p_Rt\u0014BA0\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}#\u0002\"\u00023T\u0001\u0004A\u0016!D3om&\u0014xN\\7f]RLE\rC\u0003g\u0001\u0011\u0005q-A\u000fu_BtEj\u001c8hKN$(+\u001e8oS:<G)\u001a9m_flWM\u001c;t)\t1\u0005\u000eC\u0003jK\u0002\u0007!.\u0001\u0003u_Bt\u0005CA\nl\u0013\taGCA\u0002J]RDQA\u001c\u0001\u0005\u0002=\fa\u0003^8q\u001d\u0012+\u0007\u000f\\8z[\u0016tGo\u001d\"z'R\fG/\u001a\u000b\u0004\rB\f\b\"\u0002&n\u0001\u0004Y\u0005\"B5n\u0001\u0004Q\u0007\"B:\u0001\t\u0003!\u0018AI1wKJ\fw-\u001a#ve\u0006$\u0018n\u001c8EKBdw._7f]R\u001cxJ^3s)&lW\rF\u0001G\u0011\u00151\b\u0001\"\u0001u\u0003\u0005\"x\u000e^1m'V\u001c7-Z:tMVdG)\u001a9m_flWM\u001c;EkJ\fG/[8o\u0011\u0015A\b\u0001\"\u0001z\u0003\u0011\u0011\u0017N\\:\u0015\u0007\u0019Sx\u0010C\u0003|o\u0002\u0007A0\u0001\u0005cS:\u001cF/\u0019:u!\r\u0019RP[\u0005\u0003}R\u0011aa\u00149uS>t\u0007BBA\u0001o\u0002\u0007A0\u0001\u0004cS:,e\u000e\u001a\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0003Ii\u0017\r^2i\u0003\u0012$7i\u001c8tiJ\f\u0017N\u001c;\u0015\t\u0005%\u0011q\u0002\t\u0004'\u0005-\u0011bAA\u0007)\t\u0019\u0011I\\=\t\r)\u000b\u0019\u00011\u0001L\u0011\u001d\t\u0019\u0002\u0001C\u0005\u0003+\t1b]3mK\u000e$8i\\;oiR\ta\bC\u0004\u0002\u001a\u0001!I!!\u0006\u0002!=\u0014H-\u001a:Cs\u000e{WO\u001c;EKN\u001c\u0007bBA\u000f\u0001\u0011%\u0011QC\u0001\u0011OJ|W\u000f\u001d\"z\u0003B\u0004\u0018I\u001c3F]ZDq!!\t\u0001\t\u0013\t)\"A\nhe>,\bOQ=ZK\u0006\u0014\u0018I\u001c3N_:$\b\u000eC\u0004\u0002&\u0001!I!!\u0006\u0002A\u0011,\u0007\u000f\\8z)\u0006\u001c8\u000eV=qKN|E\u000f[3s)\"\fgNU8mY\n\f7m\u001b\u0005\b\u0003S\u0001A\u0011BA\u000b\u00035!wN\\3XSRD'+\u001a;ss\"9\u0011Q\u0006\u0001\u0005\n\u0005U\u0011\u0001\u00023p]\u0016Dq!!\r\u0001\t\u0013\t)\"\u0001\u0006o_R\u0014V\r\u001e:jK\u0012Dq!!\u000e\u0001\t\u0013\t)\"\u0001\ttk64\u0015-\u001b7ve\u0016\u001cu.\u001e8ug\"9\u0011\u0011\b\u0001\u0005\n\u0005U\u0011AG8sI\u0016\u0014()\u001f$bS2,(/Z\"pk:$8+^7EKN\u001c\u0007bBA\u001f\u0001\u0011%\u0011QC\u0001\u0015C\u0012$7+^2dKN\u001c8i\u001c8tiJ\f\u0017N\u001c;\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002\u0016\u0005\u0019\u0012\r\u001a3GC&dW\rZ\"p]N$(/Y5oi\"9\u0011Q\t\u0001\u0005\n\u0005U\u0011\u0001F1eI\u0006\u0013wN\u001d;fI\u000e{gn\u001d;sC&tG\u000fC\u0004\u0002J\u0001!I!!\u0006\u0002+\u0005$GMU8mY\n\f7m[\"p]N$(/Y5oi\u001e9\u0011Q\n\u0002\t\u0002\u0005=\u0013aH*rY\u0012+\u0007\u000f\\8z[\u0016tG\u000fV1tW\u0006s\u0017\r\\=uS\u000e\u001c\u0018+^3ssB\u0019q'!\u0015\u0007\r\u0005\u0011\u0001\u0012AA*'\r\t\tF\u0005\u0005\bg\u0005EC\u0011AA,)\t\ty\u0005\u0003\u0006\u0002\\\u0005E#\u0019!C\u0005\u0003;\n\u0011bQ(V\u001dR{\u0016\t\u0014'\u0016\u0005\u0005}\u0003c\u0001\u0016\u0002b%\u0019\u00111M\u0016\u0003\u0015M\u000bH\u000eT5uKJ\fG\u000eC\u0005\u0002h\u0005E\u0003\u0015!\u0003\u0002`\u0005Q1iT+O)~\u000bE\n\u0014\u0011\t\u0015\u0005-\u0014\u0011\u000bb\u0001\n\u0013\ti'\u0001\tB-\u0016\u0013\u0016iR#`\tV\u0013\u0016\tV%P\u001dV\u0011\u0011q\u000e\t\u0004U\u0005E\u0014bAA:W\t\t2+[7qY\u0016\u001c\u0016\u000f\u001c$v]\u000e$\u0018n\u001c8\t\u0013\u0005]\u0014\u0011\u000bQ\u0001\n\u0005=\u0014!E!W\u000bJ\u000bu)R0E+J\u000bE+S(OA!Q\u00111PA)\u0005\u0004%I!!\u001c\u0002#M+Vj\u0018$B\u00132+&+R0D\u001fVsE\u000bC\u0005\u0002\u0000\u0005E\u0003\u0015!\u0003\u0002p\u0005\u00112+V'`\r\u0006KE*\u0016*F?\u000e{UK\u0014+!\u0001")
public class SqlDeploymentTaskAnalyticsQuery {
    private final SqlDialect sqlDialect;
    private final SelectBuilder selectBuilder;

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public SelectBuilder selectBuilder() {
        return this.selectBuilder;
    }

    public void throughputByDeploymentResult(DeploymentResult status) {
        this.groupByYearAndMonth();
        this.selectCount();
        this.matchAddConstraint(status);
    }

    public void countByDeploymentResult(DeploymentResult status) {
        this.selectCount();
        this.matchAddConstraint(status);
    }

    public void totalsByAppAndEnv(String applicationName, String environmentId) {
        this.selectCount();
        this.deployTaskTypesOtherThanRollback();
        this.selectBuilder().where(SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.main_application(), applicationName)).where(SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.environment(), environmentId));
    }

    public void topNLongestRunningDeployments(int topN) {
        this.selectBuilder().select(SqlDeploymentTaskAnalyticsQuery$.MODULE$.com$xebialabs$deployit$task$archive$sql$reports$SqlDeploymentTaskAnalyticsQuery$$AVERAGE_DURATION()).orderBy(OrderBy$.MODULE$.desc(SqlDeploymentTaskAnalyticsQuery$.MODULE$.com$xebialabs$deployit$task$archive$sql$reports$SqlDeploymentTaskAnalyticsQuery$$AVERAGE_DURATION()));
        this.selectBuilder().limit(topN);
        this.notRetried();
        this.deployTaskTypesOtherThanRollback();
        this.groupByAppAndEnv();
    }

    public void topNDeploymentsByState(DeploymentResult status, int topN) {
        this.groupByAppAndEnv();
        this.selectCount();
        this.orderByCountDesc();
        this.selectBuilder().limit(topN);
        DeploymentResult deploymentResult = status;
        if (((Object)((Object)DeploymentResult.SUCCESS)).equals((Object)deploymentResult)) {
            this.addSuccessConstraint();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (((Object)((Object)DeploymentResult.FAILED)).equals((Object)deploymentResult)) {
            this.sumFailureCounts();
            this.addFailedConstraint();
            this.orderByFailureCountSumDesc();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException("topNDeploymentsByState called with invalid deploymentResult");
        }
    }

    public void averageDurationDeploymentsOverTime() {
        this.groupByYearAndMonth();
        this.selectCount();
        this.selectBuilder().select(SqlDeploymentTaskAnalyticsQuery$.MODULE$.com$xebialabs$deployit$task$archive$sql$reports$SqlDeploymentTaskAnalyticsQuery$$AVERAGE_DURATION());
        this.deployTaskTypesOtherThanRollback();
        this.done();
    }

    public void totalSuccessfulDeploymentDuration() {
        this.selectCount();
        this.selectBuilder().select(SqlDeploymentTaskAnalyticsQuery$.MODULE$.com$xebialabs$deployit$task$archive$sql$reports$SqlDeploymentTaskAnalyticsQuery$$AVERAGE_DURATION()).select(this.sqlDialect().standardDeviation(ArchivedDeploymentTasks$.MODULE$.duration()));
        this.addSuccessConstraint();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void bins(Option<Object> binStart, Option<Object> binEnd) {
        this.selectCount();
        this.deployTaskTypesOtherThanRollback();
        this.done();
        Tuple2 tuple2 = new Tuple2(binStart, binEnd);
        if (tuple2 != null) {
            Option binStart2 = (Option)tuple2._1();
            Option option = (Option)tuple2._2();
            if (binStart2 instanceof Some) {
                Some some = (Some)binStart2;
                if (None$.MODULE$.equals(option)) {
                    this.selectBuilder().where(SqlCondition$.MODULE$.largerThen(ArchivedDeploymentTasks$.MODULE$.duration(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)some.get()))));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Option binStart3 = (Option)tuple2._1();
            Option binEnd2 = (Option)tuple2._2();
            if (binStart3 instanceof Some) {
                Some some = (Some)binStart3;
                if (binEnd2 instanceof Some) {
                    Some some2 = (Some)binEnd2;
                    this.selectBuilder().where(SqlCondition$.MODULE$.largerThen(ArchivedDeploymentTasks$.MODULE$.duration(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)some.get())))).where(SqlCondition$.MODULE$.smallerOrEqual(ArchivedDeploymentTasks$.MODULE$.duration(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)some2.get()))));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option binEnd3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && binEnd3 instanceof Some) {
                Some some = (Some)binEnd3;
                this.selectBuilder().where(SqlCondition$.MODULE$.smallerOrEqual(ArchivedDeploymentTasks$.MODULE$.duration(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)some.get()))));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)tuple2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Object matchAddConstraint(DeploymentResult status) {
        SelectBuilder selectBuilder;
        DeploymentResult deploymentResult = status;
        if (((Object)((Object)DeploymentResult.ROLLBACK)).equals((Object)deploymentResult)) {
            selectBuilder = this.addRollbackConstraint();
        } else if (((Object)((Object)DeploymentResult.SUCCESS)).equals((Object)deploymentResult)) {
            selectBuilder = this.addSuccessConstraint();
        } else if (((Object)((Object)DeploymentResult.FAILED)).equals((Object)deploymentResult)) {
            selectBuilder = this.addFailedConstraint();
        } else if (((Object)((Object)DeploymentResult.ABORTED)).equals((Object)deploymentResult)) {
            selectBuilder = this.addAbortedConstraint();
        } else if (((Object)((Object)DeploymentResult.TOTAL)).equals((Object)deploymentResult)) {
            selectBuilder = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)deploymentResult);
        }
        return selectBuilder;
    }

    private SelectBuilder selectCount() {
        return this.selectBuilder().select(SqlDeploymentTaskAnalyticsQuery$.MODULE$.com$xebialabs$deployit$task$archive$sql$reports$SqlDeploymentTaskAnalyticsQuery$$COUNT_ALL());
    }

    private SelectBuilder orderByCountDesc() {
        return (SelectBuilder)this.selectBuilder().orderBy(OrderBy$.MODULE$.desc(SqlDeploymentTaskAnalyticsQuery$.MODULE$.com$xebialabs$deployit$task$archive$sql$reports$SqlDeploymentTaskAnalyticsQuery$$COUNT_ALL()));
    }

    private SelectBuilder groupByAppAndEnv() {
        return this.selectBuilder().select(ArchivedDeploymentTasks$.MODULE$.main_application()).select(ArchivedDeploymentTasks$.MODULE$.environment()).groupBy(ArchivedDeploymentTasks$.MODULE$.main_application()).groupBy(ArchivedDeploymentTasks$.MODULE$.environment());
    }

    private SelectBuilder groupByYearAndMonth() {
        return this.selectBuilder().select(this.sqlDialect().year(ArchivedDeploymentTasks$.MODULE$.start_date())).select(this.sqlDialect().month(ArchivedDeploymentTasks$.MODULE$.start_date())).groupBy(this.sqlDialect().year(ArchivedDeploymentTasks$.MODULE$.start_date())).groupBy(this.sqlDialect().month(ArchivedDeploymentTasks$.MODULE$.start_date()));
    }

    private SelectBuilder deployTaskTypesOtherThanRollback() {
        return this.selectBuilder().where(SqlCondition$.MODULE$.in(ArchivedDeploymentTasks$.MODULE$.task_type(), EnumSet.of(TaskType.INITIAL, TaskType.UNDEPLOY, TaskType.UPGRADE)));
    }

    private SelectBuilder doneWithRetry() {
        return this.selectBuilder().where(SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.status(), TaskExecutionState.DONE.name())).where(SqlCondition$.MODULE$.largerThen(ArchivedDeploymentTasks$.MODULE$.failure_count(), Predef$.MODULE$.int2Integer(0)));
    }

    private SelectBuilder done() {
        return this.selectBuilder().where(SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.status(), TaskExecutionState.DONE.name())).where(SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.failure_count(), Predef$.MODULE$.int2Integer(0)));
    }

    private SelectBuilder notRetried() {
        return this.selectBuilder().where(SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.failure_count(), Predef$.MODULE$.int2Integer(0)));
    }

    private SelectBuilder sumFailureCounts() {
        return this.selectBuilder().select(SqlDeploymentTaskAnalyticsQuery$.MODULE$.com$xebialabs$deployit$task$archive$sql$reports$SqlDeploymentTaskAnalyticsQuery$$SUM_FAILURE_COUNT());
    }

    private SelectBuilder orderByFailureCountSumDesc() {
        return (SelectBuilder)this.selectBuilder().orderBy(OrderBy$.MODULE$.desc(SqlDeploymentTaskAnalyticsQuery$.MODULE$.com$xebialabs$deployit$task$archive$sql$reports$SqlDeploymentTaskAnalyticsQuery$$SUM_FAILURE_COUNT()));
    }

    private SelectBuilder addSuccessConstraint() {
        this.deployTaskTypesOtherThanRollback();
        return this.done();
    }

    private SelectBuilder addFailedConstraint() {
        this.deployTaskTypesOtherThanRollback();
        return this.doneWithRetry();
    }

    private SelectBuilder addAbortedConstraint() {
        this.deployTaskTypesOtherThanRollback();
        return this.selectBuilder().where(SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.status(), TaskExecutionState.CANCELLED.name()));
    }

    private SelectBuilder addRollbackConstraint() {
        return this.selectBuilder().where(SqlCondition$.MODULE$.equals((Selectable)ArchivedDeploymentTasks$.MODULE$.task_type(), TaskType.ROLLBACK.name()));
    }

    public SqlDeploymentTaskAnalyticsQuery(DateTime begin, DateTime end, SqlDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
        this.selectBuilder = new SelectBuilder(ArchivedDeploymentTasks$.MODULE$.tableName(), sqlDialect).where(SqlCondition$.MODULE$.between(ArchivedDeploymentTasks$.MODULE$.start_date(), begin, end));
    }
}

