/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.agrona.MutableDirectBuffer;

public class ExpandableDirectBufferOutputStream
extends OutputStream {
    private MutableDirectBuffer buffer;
    private int offset;
    private int position;

    public ExpandableDirectBufferOutputStream() {
    }

    public ExpandableDirectBufferOutputStream(MutableDirectBuffer buffer) {
        this.wrap(buffer, 0);
    }

    public ExpandableDirectBufferOutputStream(MutableDirectBuffer buffer, int offset) {
        this.wrap(buffer, offset);
    }

    public void wrap(MutableDirectBuffer buffer) {
        this.wrap(buffer, 0);
    }

    public void wrap(MutableDirectBuffer buffer, int offset) {
        Objects.requireNonNull(buffer, "Buffer must not be null");
        if (!buffer.isExpandable()) {
            throw new IllegalStateException("buffer must be expandable.");
        }
        this.buffer = buffer;
        this.offset = offset;
        this.position = 0;
    }

    public int position() {
        return this.position;
    }

    public int offset() {
        return this.offset;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.putByte(this.offset + this.position, (byte)b);
        ++this.position;
    }

    @Override
    public void write(byte[] srcBytes, int srcOffset, int length) throws IOException {
        this.buffer.putBytes(this.offset + this.position, srcBytes, srcOffset, length);
        this.position += length;
    }
}

