/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.config;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.jdbc.InstrumentedDataSource;
import com.xebialabs.deployit.core.config.DatabaseConfig;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlDialect$;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Marker;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Configuration
@EnableTransactionManagement
@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u00015\u0011\u0001cU9m\u0007>tg-[4ve\u0006$\u0018n\u001c8\u000b\u0005\r!\u0011AB2p]\u001aLwM\u0003\u0002\u0006\r\u0005!1m\u001c:f\u0015\t9\u0001\"\u0001\u0005eKBdw._5u\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0012\u0001C4sSjTH.\u001a3\n\u0005m1\"a\u0002'pO\u001eLgn\u001a\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005I\u0001\u0010\u001c3D_:4\u0017n\u001a\t\u0003?\u0001j\u0011AA\u0005\u0003C\t\u0011\u0011\u0002\u00177e\u0007>tg-[4\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\t)c\u0005\u0005\u0002 \u0001!)QD\ta\u0001=!)\u0001\u0006\u0001C\u0001S\u0005qQ.Y5o\t\u0006$\u0018mU8ve\u000e,W#\u0001\u0016\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013aA:rY*\tq&A\u0003kCZ\f\u00070\u0003\u00022Y\tQA)\u0019;b'>,(oY3)\t\u001d\u001at\b\u0011\t\u0003iuj\u0011!\u000e\u0006\u0003m]\n!\"\u00198o_R\fG/[8o\u0015\tA\u0014(A\u0004d_:$X\r\u001f;\u000b\u0005iZ\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003q\n1a\u001c:h\u0013\tqTG\u0001\u0003CK\u0006t\u0017!\u00043fgR\u0014x._'fi\"|G-I\u0001B\u0003\u0015\u0019Gn\\:f\u0011\u0015\u0019\u0005\u0001\"\u0001*\u0003Mi\u0017-\u001b8ECR\f7k\\;sG\u0016\u0004&o\u001c=zQ\t\u00115\u0007C\u0003G\u0001\u0011\u0005\u0011&A\nsKB|'\u000f^5oO\u0012\u000bG/Y*pkJ\u001cW\r\u000b\u0003Fg}\u0002\u0005\"B%\u0001\t\u0013Q\u0015AF5ogR\u0014X/\\3oi\u0016$G)\u0019;b'>,(oY3\u0015\u0007-+&\f\u0005\u0002M'6\tQJ\u0003\u0002O\u001f\u0006!!\u000e\u001a2d\u0015\t\u0001\u0016+A\u0004nKR\u0014\u0018nY:\u000b\u0005IS\u0011!\u0002;rI\u00164\u0018B\u0001+N\u0005YIen\u001d;sk6,g\u000e^3e\t\u0006$\u0018mU8ve\u000e,\u0007\"\u0002,I\u0001\u00049\u0016\u0001\u00033bi\u0006\u0014\u0017m]3\u0011\u0005}A\u0016BA-\u0003\u00059!\u0015\r^1cCN,7i\u001c8gS\u001eDQa\u0017%A\u0002q\u000bAA\\1nKB\u0011Q\f\u001a\b\u0003=\n\u0004\"a\u0018\t\u000e\u0003\u0001T!!\u0019\u0007\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0007#\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2\u0011\u0011\u0015A\u0007\u0001\"\u0001j\u00039i\u0017-\u001b8Tc2$\u0015.\u00197fGR,\u0012A\u001b\t\u0003W6l\u0011\u0001\u001c\u0006\u0003[\u0011I!A\u001c7\u0003\u0015M\u000bH\u000eR5bY\u0016\u001cG\u000f\u000b\u0002hg!)\u0011\u000f\u0001C\u0001S\u0006\u0019\"/\u001a9peRLgnZ*rY\u0012K\u0017\r\\3di\"\u0012\u0001o\r\u0005\u0006i\u0002!\t!^\u0001\u0011[\u0006LgN\u00133cGR+W\u000e\u001d7bi\u0016,\u0012A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003\u000beT!AT\u001d\n\u0005mD(\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007FA:4\u0011\u0015q\b\u0001\"\u0001\u0000\u0003Yi\u0017-\u001b8Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014XCAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004s\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\tY!!\u0002\u00035Ac\u0017\r\u001e4pe6$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:)\u0005u\u001c\u0004BBA\t\u0001\u0011\u0005q0A\u000esKB|'\u000f^5oOR\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0015\u0004\u0003\u001f\u0019\u0004bBA\f\u0001\u0011\u0005\u0011\u0011D\u0001\u0017S:LG/[1mSj,W*Y5o\t\u0006$\u0018MY1tKV\u0011\u00111\u0004\t\u0004\u001f\u0005u\u0011bAA\u0010!\t!QK\\5uQ\u0011\t)\"a\t\u0011\t\u0005\u0015\u0012\u0011F\u0007\u0003\u0003OQ!A\u000e\u0018\n\t\u0005-\u0012q\u0005\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\t\u000f\u0005=\u0002\u0001\"\u0001\u0002\u001a\u0005Y\u0012N\\5uS\u0006d\u0017N_3SKB|'\u000f^5oO\u0012\u000bG/\u00192bg\u0016DC!!\f\u0002$!9\u0011Q\u0007\u0001\u0005\n\u0005]\u0012aD;qI\u0006$X\rT5rk&\u0014\u0017m]3\u0015\r\u0005m\u0011\u0011HA\u001f\u0011\u001d\tY$a\rA\u0002q\u000baa]2iK6\f\u0007bBA \u0003g\u0001\rAK\u0001\u000bI\u0006$\u0018mU8ve\u000e,\u0007bBA\"\u0001\u0011\u0005\u0011QI\u0001\rQ&\\\u0017M]5D_:4\u0017n\u001a\u000b\u0007\u0003\u000f\n9&!\u0017\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u00051\u0001.[6be&T1!!\u0015\u000b\u0003\u0019Q\u0018\r\u001f=fe&!\u0011QKA&\u00051A\u0015n[1sS\u000e{gNZ5h\u0011\u0019\u0019\u0011\u0011\ta\u0001/\"9\u00111LA!\u0001\u0004a\u0016\u0001\u00039p_2t\u0015-\\3)\u0007\u0001\ty\u0006\u0005\u0003\u0002b\u0005\u0015TBAA2\u0015\r1\u0014QA\u0005\u0005\u0003O\n\u0019GA\u000eF]\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hK6,g\u000e\u001e\u0015\u0004\u0001\u0005-\u0004c\u0001\u001b\u0002n%\u0019\u0011qN\u001b\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0001")
public class SqlConfiguration
implements Logging {
    private final XldConfig xldConfig;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfiguration sqlConfiguration = this;
        synchronized (sqlConfiguration) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean(destroyMethod="close")
    public DataSource mainDataSource() {
        return this.instrumentedDataSource(this.xldConfig.repository().database(), "MainPool");
    }

    @Bean
    public DataSource mainDataSourceProxy() {
        return new TransactionAwareDataSourceProxy(this.mainDataSource());
    }

    @Bean(destroyMethod="close")
    public DataSource reportingDataSource() {
        return this.instrumentedDataSource(this.xldConfig.reporting().database(), "ReportingPool");
    }

    private InstrumentedDataSource instrumentedDataSource(DatabaseConfig database, String name) {
        return new InstrumentedDataSource((DataSource)new HikariDataSource(this.hikariConfig(database, name)), MetricRegistry.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public SqlDialect mainSqlDialect() {
        void var1_1;
        SqlDialect dialect = SqlDialect$.MODULE$.detectDialect(this.mainDataSource());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected SQL dialect for main: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dialect})));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public SqlDialect reportingSqlDialect() {
        void var1_1;
        SqlDialect dialect = SqlDialect$.MODULE$.detectDialect(this.reportingDataSource());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected SQL dialect for reporting: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dialect})));
        return var1_1;
    }

    @Bean
    public JdbcTemplate mainJdbcTemplate() {
        return new JdbcTemplate(this.mainDataSource());
    }

    @Bean
    public PlatformTransactionManager mainTransactionManager() {
        return new DataSourceTransactionManager(this.mainDataSource());
    }

    @Bean
    public PlatformTransactionManager reportingTransactionManager() {
        return new DataSourceTransactionManager(this.reportingDataSource());
    }

    @PostConstruct
    public void initializeMainDatabase() {
        this.updateLiquibase("com/xebialabs/xldeploy/db/main-schema.yaml", this.mainDataSource());
    }

    @PostConstruct
    public void initializeReportingDatabase() {
        this.updateLiquibase("com/xebialabs/xldeploy/db/reporting-schema.yaml", this.reportingDataSource());
    }

    private void updateLiquibase(String schema, DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            new Liquibase(schema, (ResourceAccessor)new ClassLoaderResourceAccessor(), (DatabaseConnection)new JdbcConnection(connection)).update("");
        }
    }

    /*
     * WARNING - void declaration
     */
    public HikariConfig hikariConfig(DatabaseConfig config, String poolName) {
        void var3_3;
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(config.driverClassname());
        hikariConfig.setJdbcUrl(config.url());
        hikariConfig.setUsername(config.username());
        hikariConfig.setPassword(config.password());
        hikariConfig.setMaximumPoolSize(config.maxPoolSize());
        hikariConfig.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        hikariConfig.setPoolName(poolName);
        hikariConfig.setAutoCommit(false);
        hikariConfig.setLeakDetectionThreshold(15000L);
        return var3_3;
    }

    public SqlConfiguration(XldConfig xldConfig) {
        this.xldConfig = xldConfig;
        Logging.$init$((Logging)this);
    }
}

