/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.transport.tcp.async;

import com.hierynomus.protocol.Packet;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.transport.PacketHandlers;
import com.hierynomus.protocol.transport.TransportException;
import com.hierynomus.protocol.transport.TransportLayer;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.transport.tcp.async.AsyncPacketReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDirectTcpTransport<P extends Packet<?>>
implements TransportLayer<P> {
    public static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DIRECT_HEADER_SIZE = 4;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PacketHandlers<P> handlers;
    private final AsynchronousSocketChannel socketChannel;
    private final AsyncPacketReader<P> packetReader;
    private int soTimeout = 0;
    private final Queue<ByteBuffer> writeQueue;
    private boolean writingNow = false;

    public AsyncDirectTcpTransport(int soTimeout, PacketHandlers<P> handlers, AsynchronousChannelGroup group) throws IOException {
        this.soTimeout = soTimeout;
        this.handlers = handlers;
        this.socketChannel = AsynchronousSocketChannel.open(group);
        this.packetReader = new AsyncPacketReader<P>(this.socketChannel, handlers.getPacketFactory(), handlers.getReceiver());
        this.writeQueue = new LinkedBlockingQueue<ByteBuffer>();
    }

    @Override
    public void write(P packet) throws TransportException {
        ByteBuffer bufferToSend = this.prepareBufferToSend(packet);
        this.logger.trace("Sending packet << {} >>", packet);
        try {
            this.writeOrEnqueue(bufferToSend);
        }
        catch (IOException ioe) {
            throw TransportException.Wrapper.wrap(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOrEnqueue(ByteBuffer buffer) throws IOException {
        AsyncDirectTcpTransport asyncDirectTcpTransport = this;
        synchronized (asyncDirectTcpTransport) {
            if (!this.writingNow) {
                this.writingNow = true;
                this.startAsyncWrite(buffer);
            } else {
                this.writeQueue.add(buffer);
            }
        }
    }

    @Override
    public void connect(InetSocketAddress remoteAddress) throws IOException {
        String remoteHostname = remoteAddress.getHostString();
        Future<Void> connectFuture = this.socketChannel.connect(remoteAddress);
        try {
            connectFuture.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw TransportException.Wrapper.wrap(e);
        }
        this.packetReader.start(remoteHostname, this.soTimeout);
    }

    @Override
    public void disconnect() throws IOException {
        this.socketChannel.close();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isOpen();
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    private void startAsyncWrite(ByteBuffer toSend) {
        this.socketChannel.write(toSend, this.soTimeout, TimeUnit.MILLISECONDS, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer result, Object attachment) {
                this.startNextWriteIfWaiting();
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                this.startNextWriteIfWaiting();
                AsyncDirectTcpTransport.this.handlers.getReceiver().handleError(exc);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void startNextWriteIfWaiting() {
                AsyncDirectTcpTransport asyncDirectTcpTransport = AsyncDirectTcpTransport.this;
                synchronized (asyncDirectTcpTransport) {
                    ByteBuffer nextBufferToWrite = (ByteBuffer)AsyncDirectTcpTransport.this.writeQueue.poll();
                    if (nextBufferToWrite != null) {
                        AsyncDirectTcpTransport.this.startAsyncWrite(nextBufferToWrite);
                    } else {
                        AsyncDirectTcpTransport.this.writingNow = false;
                    }
                }
            }
        });
    }

    private ByteBuffer prepareBufferToSend(P packet) {
        Object packetData = this.handlers.getSerializer().write(packet);
        int dataSize = ((Buffer)packetData).available();
        ByteBuffer toSend = ByteBuffer.allocate(dataSize + 4);
        toSend.order(ByteOrder.BIG_ENDIAN);
        toSend.putInt(((Buffer)packetData).available());
        toSend.put(((Buffer)packetData).array(), ((Buffer)packetData).rpos(), ((Buffer)packetData).available());
        toSend.flip();
        try {
            ((Buffer)packetData).skip(dataSize);
        }
        catch (Buffer.BufferException e) {
            throw SMBRuntimeException.Wrapper.wrap(e);
        }
        return toSend;
    }
}

