/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

public class WindowsCommandLineArgsSanitizer {
    private static final char[] SPECIAL_CHARS = " |<>&^\r\n".toCharArray();
    private static final String WHITE_SPACE = " ";

    public static String sanitize(String str) {
        if (str.contains(WHITE_SPACE)) {
            return "\"" + str + "\"";
        }
        return WindowsCommandLineArgsSanitizer.escapeSpecialCharacters(str);
    }

    private static String escapeSpecialCharacters(String str) {
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < str.length(); ++j) {
            char c = str.charAt(j);
            if (WindowsCommandLineArgsSanitizer.contains(c, SPECIAL_CHARS)) {
                builder.append('^');
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean contains(char c, char[] chars) {
        for (char caret_char : chars) {
            if (caret_char != c) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnySpecialChars(String str) {
        for (char c : SPECIAL_CHARS) {
            if (str.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }
}

