/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.winrm.soap;

import com.xebialabs.overthere.winrm.Namespaces;
import com.xebialabs.overthere.winrm.soap.KeyValuePair;
import com.xebialabs.overthere.winrm.soap.Soapy;
import java.net.URI;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class HeaderBuilder {
    private Element header;

    public HeaderBuilder(Element header) {
        this.header = header;
    }

    public HeaderBuilder to(URI address) {
        this.header.addElement(QName.get((String)"To", (Namespace)Namespaces.NS_ADDRESSING)).addText(address.toString());
        return this;
    }

    public HeaderBuilder replyTo(URI address) {
        Element replyTo = this.header.addElement(QName.get((String)"ReplyTo", (Namespace)Namespaces.NS_ADDRESSING));
        Soapy.mustUnderstand(replyTo.addElement(QName.get((String)"Address", (Namespace)Namespaces.NS_ADDRESSING))).addText(address.toString());
        return this;
    }

    public HeaderBuilder maxEnvelopeSize(int size) {
        Soapy.mustUnderstand(this.header.addElement(QName.get((String)"MaxEnvelopeSize", (Namespace)Namespaces.NS_WSMAN_DMTF))).addText("" + size);
        return this;
    }

    public HeaderBuilder withId(String id) {
        this.header.addElement(QName.get((String)"MessageID", (Namespace)Namespaces.NS_ADDRESSING)).addText(id);
        return this;
    }

    public HeaderBuilder withLocale(String locale) {
        Soapy.needNotUnderstand(this.header.addElement(QName.get((String)"Locale", (Namespace)Namespaces.NS_WSMAN_DMTF))).addAttribute("xml:lang", locale);
        Soapy.needNotUnderstand(this.header.addElement(QName.get((String)"DataLocale", (Namespace)Namespaces.NS_WSMAN_MSFT))).addAttribute("xml:lang", locale);
        return this;
    }

    public HeaderBuilder withTimeout(String timeout) {
        this.header.addElement(QName.get((String)"OperationTimeout", (Namespace)Namespaces.NS_WSMAN_DMTF)).addText(timeout);
        return this;
    }

    public HeaderBuilder withAction(URI uri) {
        Soapy.mustUnderstand(this.header.addElement(QName.get((String)"Action", (Namespace)Namespaces.NS_ADDRESSING))).addText(uri.toString());
        return this;
    }

    public HeaderBuilder withShellId(String shellId) {
        this.header.addElement(QName.get((String)"SelectorSet", (Namespace)Namespaces.NS_WSMAN_DMTF)).addElement(QName.get((String)"Selector", (Namespace)Namespaces.NS_WSMAN_DMTF)).addAttribute("Name", "ShellId").addText(shellId);
        return this;
    }

    public HeaderBuilder withResourceURI(URI uri) {
        Soapy.mustUnderstand(this.header.addElement(QName.get((String)"ResourceURI", (Namespace)Namespaces.NS_WSMAN_DMTF))).addText(uri.toString());
        return this;
    }

    public HeaderBuilder withOptionSet(List<KeyValuePair> options) {
        Element optionSet = this.header.addElement(QName.get((String)"OptionSet", (Namespace)Namespaces.NS_WSMAN_DMTF));
        for (KeyValuePair p : options) {
            optionSet.addElement(QName.get((String)"Option", (Namespace)Namespaces.NS_WSMAN_DMTF)).addAttribute("Name", p.getKey()).addText(p.getValue());
        }
        return this;
    }
}

