/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.protobuf.ByteString;
import akka.remote.MessageSerializer;
import akka.remote.WireFormats;
import akka.remote.artery.EnvelopeBuffer;
import akka.remote.artery.HeaderBuilder;
import akka.remote.artery.OutboundEnvelope;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class MessageSerializer$ {
    public static MessageSerializer$ MODULE$;

    static {
        new MessageSerializer$();
    }

    public Object deserialize(ExtendedActorSystem system, WireFormats.SerializedMessage messageProtocol) {
        return ((Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)system)).deserialize(messageProtocol.getMessage().toByteArray(), messageProtocol.getSerializerId(), messageProtocol.hasMessageManifest() ? messageProtocol.getMessageManifest().toStringUtf8() : "").get();
    }

    public WireFormats.SerializedMessage serialize(ExtendedActorSystem system, Object message) {
        WireFormats.SerializedMessage serializedMessage;
        Serialization s = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)system);
        Serializer serializer = s.findSerializerFor(message);
        WireFormats.SerializedMessage.Builder builder = WireFormats.SerializedMessage.newBuilder();
        try {
            BoxedUnit boxedUnit;
            builder.setMessage(ByteString.copyFrom((byte[])serializer.toBinary(message)));
            builder.setSerializerId(serializer.identifier());
            Serializer serializer2 = serializer;
            if (serializer2 instanceof SerializerWithStringManifest) {
                String manifest;
                SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer2;
                String string = manifest = serializerWithStringManifest.manifest(message);
                String string2 = "";
                boxedUnit = (string == null ? string2 != null : !string.equals(string2)) ? builder.setMessageManifest(ByteString.copyFromUtf8((String)manifest)) : BoxedUnit.UNIT;
            } else {
                boxedUnit = serializer.includeManifest() ? builder.setMessageManifest(ByteString.copyFromUtf8((String)message.getClass().getName())) : BoxedUnit.UNIT;
            }
            serializedMessage = builder.build();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new MessageSerializer.SerializationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to serialize remote message [", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.getClass()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using serializer [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serializer.getClass()})), e);
            }
            throw throwable;
        }
        return serializedMessage;
    }

    public void serializeForArtery(Serialization serialization, OutboundEnvelope outboundEnvelope, HeaderBuilder headerBuilder, EnvelopeBuffer envelope) {
        Object message = outboundEnvelope.message();
        Serializer serializer = serialization.findSerializerFor(message);
        headerBuilder.setSerializer(serializer.identifier());
        Serializer serializer2 = serializer;
        if (serializer2 instanceof ByteBufferSerializer) {
            Serializer serializer3 = serializer2;
            headerBuilder.setManifest(MessageSerializer$.manifest$1(message, serializer));
            envelope.writeHeader(headerBuilder, outboundEnvelope);
            ((ByteBufferSerializer)serializer3).toBinary(message, envelope.byteBuffer());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            headerBuilder.setManifest(MessageSerializer$.manifest$1(message, serializer));
            envelope.writeHeader(headerBuilder, outboundEnvelope);
            envelope.byteBuffer().put(serializer.toBinary(message));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Object deserializeForArtery(ExtendedActorSystem system, long originUid, Serialization serialization, int serializer, String classManifest, EnvelopeBuffer envelope) {
        return serialization.deserializeByteBuffer(envelope.byteBuffer(), serializer, classManifest);
    }

    private static final String manifest$1(Object message$1, Serializer serializer$1) {
        String string;
        Serializer serializer = serializer$1;
        if (serializer instanceof SerializerWithStringManifest) {
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
            string = serializerWithStringManifest.manifest(message$1);
        } else {
            string = serializer$1.includeManifest() ? message$1.getClass().getName() : "";
        }
        return string;
    }

    private MessageSerializer$() {
        MODULE$ = this;
    }
}

