/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.exception.RuntimeIOException;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TFileReader;
import de.schlichtherle.truezip.file.TFileWriter;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFiles {
    private static final Logger logger = LoggerFactory.getLogger(TFiles.class);

    public static Supplier<InputStream> newByteSource(TFile file) {
        return () -> {
            try {
                return new TFileInputStream((File)file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(e);
            }
        };
    }

    public static Supplier<Reader> newCharSource(TFile file, CharsetDecoder decoder) {
        return () -> {
            try {
                return new TFileReader(file, decoder);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(e);
            }
        };
    }

    public static Supplier<OutputStream> newByteSink(TFile file) {
        return () -> {
            try {
                return new TFileOutputStream((File)file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(e);
            }
        };
    }

    public static Supplier<Writer> newCharSink(TFile file, boolean append, CharsetEncoder encoder) {
        return () -> {
            try {
                return new TFileWriter(file, append, encoder);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(e);
            }
        };
    }

    public static void umountQuietly(TFile file) {
        if (file == null) {
            return;
        }
        try {
            if (file.isArchive() && file.getEnclArchive() == null) {
                TVFS.umount((TFile)file);
            } else if (file.isArchive()) {
                logger.error("Trying to umount a non-top-level archive ({})", (Object)file);
            }
        }
        catch (FsSyncException e) {
            logger.error("Could not umount {}, continuing", (Object)file);
            logger.debug("Exception was: ", (Throwable)e);
        }
    }

    public static boolean isArchive(String path) {
        boolean bl;
        TFile file = null;
        try {
            file = new TFile(path);
            bl = file.isArchive();
        }
        catch (Throwable throwable) {
            TFiles.umountQuietly(file);
            throw throwable;
        }
        TFiles.umountQuietly(file);
        return bl;
    }
}

