/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl;

import akka.annotation.InternalApi;
import akka.stream.Attributes;
import akka.stream.RateExceededException;
import akka.stream.ThrottleMode;
import akka.stream.ThrottleMode$Enforcing$;
import akka.stream.ThrottleMode$Shaping$;
import akka.stream.impl.Throttle$;
import akka.stream.impl.fusing.GraphStages;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogic;
import akka.util.NanoTimeTokenBucket;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b!B\u0001\u0003\u0001\u0019A!\u0001\u0003+ie>$H\u000f\\3\u000b\u0005\r!\u0011\u0001B5na2T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\u00059\u0011\u0001B1lW\u0006,\"!C\u0011\u0014\u0005\u0001Q\u0001cA\u0006\u001d?9\u0011A\"\u0007\b\u0003\u001b]q!A\u0004\f\u000f\u0005=)bB\u0001\t\u0015\u001b\u0005\t\"B\u0001\n\u0014\u0003\u0019a$o\\8u}\r\u0001\u0011\"A\u0004\n\u0005\u00151\u0011BA\u0002\u0005\u0013\tA\"!\u0001\u0004gkNLgnZ\u0005\u00035m\t1b\u0012:ba\"\u001cF/Y4fg*\u0011\u0001DA\u0005\u0003;y\u0011acU5na2,G*\u001b8fCJ<%/\u00199i'R\fw-\u001a\u0006\u00035m\u0001\"\u0001I\u0011\r\u0001\u0011)!\u0005\u0001b\u0001G\t\tA+\u0005\u0002%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t9aj\u001c;iS:<\u0007CA\u0013,\u0013\tacEA\u0002B]fD\u0001B\f\u0001\u0003\u0006\u0004%\taL\u0001\u0005G>\u001cH/F\u00011!\t)\u0013'\u0003\u00023M\t\u0019\u0011J\u001c;\t\u0011Q\u0002!\u0011!Q\u0001\nA\nQaY8ti\u0002B\u0001B\u000e\u0001\u0003\u0006\u0004%\taN\u0001\u0004a\u0016\u0014X#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005u2\u0013AC2p]\u000e,(O]3oi&\u0011qH\u000f\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011!\t\u0005A!A!\u0002\u0013A\u0014\u0001\u00029fe\u0002B\u0001b\u0011\u0001\u0003\u0006\u0004%\taL\u0001\r[\u0006D\u0018.\\;n\u0005V\u00148\u000f\u001e\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005a\u0005iQ.\u0019=j[Vl')\u001e:ti\u0002B\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001S\u0001\u0010G>\u001cHoQ1mGVd\u0017\r^5p]V\t\u0011\n\u0005\u0003&\u0015~\u0001\u0014BA&'\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003J\u0003A\u0019wn\u001d;DC2\u001cW\u000f\\1uS>t\u0007\u0005\u0003\u0005P\u0001\t\u0015\r\u0011\"\u0001Q\u0003\u0011iw\u000eZ3\u0016\u0003E\u0003\"AU*\u000e\u0003\u0011I!\u0001\u0016\u0003\u0003\u0019QC'o\u001c;uY\u0016lu\u000eZ3\t\u0011Y\u0003!\u0011!Q\u0001\nE\u000bQ!\\8eK\u0002BQ\u0001\u0017\u0001\u0005\u0002e\u000ba\u0001P5oSRtDC\u0002.];z{\u0006\rE\u0002\\\u0001}i\u0011A\u0001\u0005\u0006]]\u0003\r\u0001\r\u0005\u0006m]\u0003\r\u0001\u000f\u0005\u0006\u0007^\u0003\r\u0001\r\u0005\u0006\u000f^\u0003\r!\u0013\u0005\u0006\u001f^\u0003\r!\u0015\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0003Iq\u0017M\\8t\u0005\u0016$x/Z3o)>\\WM\\:\u0016\u0003\u0011\u0004\"!J3\n\u0005\u00194#\u0001\u0002'p]\u001eDa\u0001\u001b\u0001!\u0002\u0013!\u0017a\u00058b]>\u001c()\u001a;xK\u0016tGk\\6f]N\u0004\u0003b\u00026\u0001\u0005\u0004%Ia[\u0001\ni&lWM\u001d(b[\u0016,\u0012\u0001\u001c\t\u0003[Ft!A\\8\u0011\u0005A1\u0013B\u00019'\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A4\u0003BB;\u0001A\u0003%A.\u0001\u0006uS6,'OT1nK\u0002BQa\u001e\u0001\u0005Ba\f1b\u0019:fCR,Gj\\4jGR\u0011\u0011p \t\u0003uvl\u0011a\u001f\u0006\u0003y\u0012\tQa\u001d;bO\u0016L!A`>\u0003\u001f\u001d\u0013\u0018\r\u001d5Ti\u0006<W\rT8hS\u000eDq!!\u0001w\u0001\u0004\t\u0019!A\nj]\",'/\u001b;fI\u0006#HO]5ckR,7\u000fE\u0002S\u0003\u000bI1!a\u0002\u0005\u0005)\tE\u000f\u001e:jEV$Xm\u001d\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0003!!xn\u0015;sS:<GCAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tA\u0001\\1oO*\u0011\u0011\u0011D\u0001\u0005U\u00064\u0018-C\u0002s\u0003'A3\u0001AA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u00121\u0005\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public class Throttle<T>
extends GraphStages.SimpleLinearGraphStage<T> {
    private final int cost;
    private final FiniteDuration per;
    private final int maximumBurst;
    private final Function1<T, Object> costCalculation;
    private final ThrottleMode mode;
    private final long akka$stream$impl$Throttle$$nanosBetweenTokens;
    private final String akka$stream$impl$Throttle$$timerName;

    public int cost() {
        return this.cost;
    }

    public FiniteDuration per() {
        return this.per;
    }

    public int maximumBurst() {
        return this.maximumBurst;
    }

    public Function1<T, Object> costCalculation() {
        return this.costCalculation;
    }

    public ThrottleMode mode() {
        return this.mode;
    }

    public long akka$stream$impl$Throttle$$nanosBetweenTokens() {
        return this.akka$stream$impl$Throttle$$nanosBetweenTokens;
    }

    public String akka$stream$impl$Throttle$$timerName() {
        return this.akka$stream$impl$Throttle$$timerName;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new TimerGraphStageLogic(this){
            private final NanoTimeTokenBucket akka$stream$impl$Throttle$$anon$$tokenBucket;
            private boolean akka$stream$impl$Throttle$$anon$$willStop;
            private T akka$stream$impl$Throttle$$anon$$currentElement;
            private final boolean akka$stream$impl$Throttle$$anon$$enforcing;
            private final /* synthetic */ Throttle $outer;

            public NanoTimeTokenBucket akka$stream$impl$Throttle$$anon$$tokenBucket() {
                return this.akka$stream$impl$Throttle$$anon$$tokenBucket;
            }

            private boolean akka$stream$impl$Throttle$$anon$$willStop() {
                return this.akka$stream$impl$Throttle$$anon$$willStop;
            }

            public void akka$stream$impl$Throttle$$anon$$willStop_$eq(boolean x$1) {
                this.akka$stream$impl$Throttle$$anon$$willStop = x$1;
            }

            private T akka$stream$impl$Throttle$$anon$$currentElement() {
                return this.akka$stream$impl$Throttle$$anon$$currentElement;
            }

            public void akka$stream$impl$Throttle$$anon$$currentElement_$eq(T x$1) {
                this.akka$stream$impl$Throttle$$anon$$currentElement = x$1;
            }

            public boolean akka$stream$impl$Throttle$$anon$$enforcing() {
                return this.akka$stream$impl$Throttle$$anon$$enforcing;
            }

            public void preStart() {
                this.akka$stream$impl$Throttle$$anon$$tokenBucket().init();
            }

            public void onTimer(Object key) {
                block0: {
                    this.push(this.$outer.out(), this.akka$stream$impl$Throttle$$anon$$currentElement());
                    this.akka$stream$impl$Throttle$$anon$$currentElement_$eq(null);
                    if (!this.akka$stream$impl$Throttle$$anon$$willStop()) break block0;
                    this.completeStage();
                }
            }

            public /* synthetic */ Throttle akka$stream$impl$Throttle$$anon$$$outer() {
                return this.$outer;
            }
            {
                boolean bl;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                this.akka$stream$impl$Throttle$$anon$$tokenBucket = new NanoTimeTokenBucket((long)$outer.maximumBurst(), $outer.akka$stream$impl$Throttle$$nanosBetweenTokens());
                this.akka$stream$impl$Throttle$$anon$$willStop = false;
                ThrottleMode throttleMode = $outer.mode();
                if (ThrottleMode$Enforcing$.MODULE$.equals(throttleMode)) {
                    bl = true;
                } else if (ThrottleMode$Shaping$.MODULE$.equals(throttleMode)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)throttleMode);
                }
                this.akka$stream$impl$Throttle$$anon$$enforcing = bl;
                InHandler handler = new InHandler(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$(this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$(this, ex);
                    }

                    public void onUpstreamFinish() {
                        if (this.$outer.isAvailable(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().out()) && this.$outer.isTimerActive(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().akka$stream$impl$Throttle$$timerName())) {
                            this.$outer.akka$stream$impl$Throttle$$anon$$willStop_$eq(true);
                        } else {
                            this.$outer.completeStage();
                        }
                    }

                    public void onPush() {
                        T elem = this.$outer.grab(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().in());
                        int cost = BoxesRunTime.unboxToInt((Object)this.$outer.akka$stream$impl$Throttle$$anon$$$outer().costCalculation().apply(elem));
                        long delayNanos = this.$outer.akka$stream$impl$Throttle$$anon$$tokenBucket().offer((long)cost);
                        if (delayNanos == 0L) {
                            this.$outer.push(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().out(), elem);
                        } else if (this.$outer.akka$stream$impl$Throttle$$anon$$enforcing()) {
                            this.$outer.failStage(new RateExceededException("Maximum throttle throughput exceeded."));
                        } else {
                            this.$outer.akka$stream$impl$Throttle$$anon$$currentElement_$eq(elem);
                            this.$outer.scheduleOnce(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().akka$stream$impl$Throttle$$timerName(), new package.DurationLong(package$.MODULE$.DurationLong(delayNanos)).nanos());
                        }
                    }

                    public void onPull() {
                        this.$outer.pull(this.$outer.akka$stream$impl$Throttle$$anon$$$outer().in());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        InHandler.$init$(this);
                        OutHandler.$init$(this);
                    }
                };
                this.setHandler($outer.in(), handler);
                this.setHandler($outer.out(), (OutHandler)((Object)handler));
            }
        };
    }

    public String toString() {
        return "Throttle";
    }

    public Throttle(int cost, FiniteDuration per, int maximumBurst, Function1<T, Object> costCalculation, ThrottleMode mode) {
        this.cost = cost;
        this.per = per;
        this.maximumBurst = maximumBurst;
        this.costCalculation = costCalculation;
        this.mode = mode;
        Predef$.MODULE$.require(cost > 0, (Function0 & Serializable & scala.Serializable)() -> "cost must be > 0");
        Predef$.MODULE$.require(per.toNanos() > 0L, (Function0 & Serializable & scala.Serializable)() -> "per time must be > 0");
        ThrottleMode throttleMode = mode;
        ThrottleMode$Enforcing$ throttleMode$Enforcing$ = ThrottleMode$Enforcing$.MODULE$;
        Predef$.MODULE$.require((throttleMode != null ? !throttleMode.equals(throttleMode$Enforcing$) : throttleMode$Enforcing$ != null) || maximumBurst >= 0, (Function0 & Serializable & scala.Serializable)() -> "maximumBurst must be > 0 in Enforcing mode");
        Predef$.MODULE$.require(per.toNanos() >= (long)cost, (Function0 & Serializable & scala.Serializable)() -> "Rates larger than 1 unit / nanosecond are not supported");
        this.akka$stream$impl$Throttle$$nanosBetweenTokens = per.toNanos() / (long)cost;
        this.akka$stream$impl$Throttle$$timerName = "ThrottleTimer";
    }
}

