/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io.compression;

import akka.annotation.InternalApi;
import akka.stream.impl.io.compression.DeflateCompressor;
import akka.stream.impl.io.compression.GzipDecompressor$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0001\u0002\u0001\u00151\u0011ab\u0012>ja\u000e{W\u000e\u001d:fgN|'O\u0003\u0002\u0004\t\u0005Y1m\\7qe\u0016\u001c8/[8o\u0015\t)a!\u0001\u0002j_*\u0011q\u0001C\u0001\u0005S6\u0004HN\u0003\u0002\n\u0015\u000511\u000f\u001e:fC6T\u0011aC\u0001\u0005C.\\\u0017m\u0005\u0002\u0001\u001bA\u0011abD\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u0012\t\u00164G.\u0019;f\u0007>l\u0007O]3tg>\u0014\b\"\u0002\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003U\u0001\"A\u0004\u0001\t\u0011]\u0001\u0001R1A\u0005Ra\t\u0001\u0002Z3gY\u0006$XM]\u000b\u00023A\u0011!$I\u0007\u00027)\u0011A$H\u0001\u0004u&\u0004(B\u0001\u0010 \u0003\u0011)H/\u001b7\u000b\u0003\u0001\nAA[1wC&\u0011!e\u0007\u0002\t\t\u00164G.\u0019;fe\"9A\u0005\u0001b\u0001\n\u0013)\u0013\u0001C2iK\u000e\\7+^7\u0016\u0003\u0019\u0002\"AG\u0014\n\u0005!Z\"!B\"S\u0007N\u0012\u0004B\u0002\u0016\u0001A\u0003%a%A\u0005dQ\u0016\u001c7nU;nA!9A\u0006\u0001a\u0001\n\u0013i\u0013A\u00035fC\u0012,'oU3oiV\ta\u0006\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004GA\u0004C_>dW-\u00198\t\u000fU\u0002\u0001\u0019!C\u0005m\u0005q\u0001.Z1eKJ\u001cVM\u001c;`I\u0015\fHCA\u001c;!\ty\u0003(\u0003\u0002:a\t!QK\\5u\u0011\u001dYD'!AA\u00029\n1\u0001\u001f\u00132\u0011\u0019i\u0004\u0001)Q\u0005]\u0005Y\u0001.Z1eKJ\u001cVM\u001c;!\u0011\u001dy\u0004\u00011A\u0005\n\u0001\u000b\u0011BY=uKN\u0014V-\u00193\u0016\u0003\u0005\u0003\"a\f\"\n\u0005\r\u0003$\u0001\u0002'p]\u001eDq!\u0012\u0001A\u0002\u0013%a)A\u0007csR,7OU3bI~#S-\u001d\u000b\u0003o\u001dCqa\u000f#\u0002\u0002\u0003\u0007\u0011\t\u0003\u0004J\u0001\u0001\u0006K!Q\u0001\u000bEf$Xm\u001d*fC\u0012\u0004\u0003\"B&\u0001\t#b\u0015AE2p[B\u0014Xm]:XSRD')\u001e4gKJ$2!\u0014*U!\tq\u0005+D\u0001P\u0015\tq\"\"\u0003\u0002R\u001f\nQ!)\u001f;f'R\u0014\u0018N\\4\t\u000bMS\u0005\u0019A'\u0002\u000b%t\u0007/\u001e;\t\u000bUS\u0005\u0019\u0001,\u0002\r\t,hMZ3s!\rys+W\u0005\u00031B\u0012Q!\u0011:sCf\u0004\"a\f.\n\u0005m\u0003$\u0001\u0002\"zi\u0016DQ!\u0018\u0001\u0005Ry\u000bqB\u001a7vg\"<\u0016\u000e\u001e5Ck\u001a4WM\u001d\u000b\u0003\u001b~CQ!\u0016/A\u0002YCQ!\u0019\u0001\u0005R\t\f\u0001CZ5oSNDw+\u001b;i\u0005V4g-\u001a:\u0015\u00055\u001b\u0007\"B+a\u0001\u00041\u0006\"B3\u0001\t\u00131\u0017!C;qI\u0006$Xm\u0011:d)\t9t\rC\u0003TI\u0002\u0007Q\nC\u0003j\u0001\u0011%!.\u0001\u0004iK\u0006$WM\u001d\u000b\u0002\u001b\")A\u000e\u0001C\u0005U\u00069AO]1jY\u0016\u0014\bF\u0001\u0001o!\ty'/D\u0001q\u0015\t\t(\"\u0001\u0006b]:|G/\u0019;j_:L!a\u001d9\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b")
@InternalApi
public class GzipCompressor
extends DeflateCompressor {
    private Deflater deflater;
    private final CRC32 checkSum = new CRC32();
    private boolean headerSent = false;
    private long bytesRead = 0L;
    private volatile boolean bitmap$0;

    private Deflater deflater$lzycompute() {
        GzipCompressor gzipCompressor = this;
        synchronized (gzipCompressor) {
            if (!this.bitmap$0) {
                this.deflater = new Deflater(9, true);
                this.bitmap$0 = true;
            }
        }
        return this.deflater;
    }

    @Override
    public Deflater deflater() {
        return !this.bitmap$0 ? this.deflater$lzycompute() : this.deflater;
    }

    private CRC32 checkSum() {
        return this.checkSum;
    }

    private boolean headerSent() {
        return this.headerSent;
    }

    private void headerSent_$eq(boolean x$1) {
        this.headerSent = x$1;
    }

    private long bytesRead() {
        return this.bytesRead;
    }

    private void bytesRead_$eq(long x$1) {
        this.bytesRead = x$1;
    }

    @Override
    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        this.updateCrc(input);
        return this.header().$plus$plus(super.compressWithBuffer(input, buffer));
    }

    @Override
    public ByteString flushWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.flushWithBuffer(buffer));
    }

    @Override
    public ByteString finishWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.finishWithBuffer(buffer)).$plus$plus(this.trailer());
    }

    private void updateCrc(ByteString input) {
        this.checkSum().update((byte[])input.toArray(ClassTag$.MODULE$.Byte()));
        this.bytesRead_$eq(this.bytesRead() + (long)input.length());
    }

    private ByteString header() {
        ByteString byteString;
        if (!this.headerSent()) {
            this.headerSent_$eq(true);
            byteString = GzipDecompressor$.MODULE$.Header();
        } else {
            byteString = ByteString$.MODULE$.empty();
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    private ByteString trailer() {
        void var3_3;
        int crc = (int)this.checkSum().getValue();
        int tot = (int)this.bytesRead();
        ByteString trailer = GzipCompressor.int32$1(crc).$plus$plus(GzipCompressor.int32$1(tot));
        return var3_3;
    }

    private static final ByteString int32$1(int i) {
        return ByteString$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{i, i >> 8, i >> 16, i >> 24}), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }
}

