/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.Aeron;
import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.FlowControl;
import io.aeron.driver.NetworkPublicationPadding3;
import io.aeron.driver.NetworkPublicationThreadLocals;
import io.aeron.driver.RetransmitHandler;
import io.aeron.driver.RetransmitSender;
import io.aeron.driver.Subscribable;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferUnblocker;
import io.aeron.logbuffer.TermScanner;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public class NetworkPublication
extends NetworkPublicationPadding3
implements RetransmitSender,
DriverManagedResource,
Subscribable {
    private final long registrationId;
    private final long unblockTimeoutNs;
    private final int positionBitsToShift;
    private final int initialTermId;
    private final int termLengthMask;
    private final int mtuLength;
    private final int termWindowLength;
    private final int sessionId;
    private final int streamId;
    private final boolean isExclusive;
    private volatile boolean isConnected = false;
    private boolean hasReachedEndOfLife = false;
    private Status status = Status.ACTIVE;
    private final UnsafeBuffer[] termBuffers;
    private final ByteBuffer[] sendBuffers;
    private final Position publisherLimit;
    private final Position senderPosition;
    private final Position senderLimit;
    private final SendChannelEndpoint channelEndpoint;
    private final ByteBuffer heartbeatBuffer;
    private final DataHeaderFlyweight heartbeatDataHeader;
    private final ByteBuffer setupBuffer;
    private final SetupFlyweight setupHeader;
    private final ByteBuffer rttMeasurementBuffer;
    private final RttMeasurementFlyweight rttMeasurementHeader;
    private final FlowControl flowControl;
    private final NanoClock nanoClock;
    private final EpochClock epochClock;
    private final RetransmitHandler retransmitHandler;
    private final RawLog rawLog;
    private final AtomicCounter heartbeatsSent;
    private final AtomicCounter retransmitsSent;
    private final AtomicCounter senderFlowControlLimits;
    private final AtomicCounter shortSends;
    private final AtomicCounter unblockedPublications;

    public NetworkPublication(long registrationId, SendChannelEndpoint channelEndpoint, NanoClock nanoClock, EpochClock epochClock, RawLog rawLog, Position publisherLimit, Position senderPosition, Position senderLimit, int sessionId, int streamId, int initialTermId, int mtuLength, SystemCounters systemCounters, FlowControl flowControl, RetransmitHandler retransmitHandler, NetworkPublicationThreadLocals threadLocals, long unblockTimeoutNs, boolean isExclusive) {
        this.registrationId = registrationId;
        this.unblockTimeoutNs = unblockTimeoutNs;
        this.channelEndpoint = channelEndpoint;
        this.rawLog = rawLog;
        this.nanoClock = nanoClock;
        this.epochClock = epochClock;
        this.senderPosition = senderPosition;
        this.senderLimit = senderLimit;
        this.flowControl = flowControl;
        this.retransmitHandler = retransmitHandler;
        this.publisherLimit = publisherLimit;
        this.mtuLength = mtuLength;
        this.initialTermId = initialTermId;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.isExclusive = isExclusive;
        this.setupBuffer = threadLocals.setupBuffer();
        this.setupHeader = threadLocals.setupHeader();
        this.heartbeatBuffer = threadLocals.heartbeatBuffer();
        this.heartbeatDataHeader = threadLocals.heartbeatDataHeader();
        this.rttMeasurementBuffer = threadLocals.rttMeasurementBuffer();
        this.rttMeasurementHeader = threadLocals.rttMeasurementHeader();
        this.heartbeatsSent = systemCounters.get(SystemCounterDescriptor.HEARTBEATS_SENT);
        this.shortSends = systemCounters.get(SystemCounterDescriptor.SHORT_SENDS);
        this.retransmitsSent = systemCounters.get(SystemCounterDescriptor.RETRANSMITS_SENT);
        this.senderFlowControlLimits = systemCounters.get(SystemCounterDescriptor.SENDER_FLOW_CONTROL_LIMITS);
        this.unblockedPublications = systemCounters.get(SystemCounterDescriptor.UNBLOCKED_PUBLICATIONS);
        this.termBuffers = rawLog.termBuffers();
        this.sendBuffers = rawLog.sliceTerms();
        int termLength = rawLog.termLength();
        this.termLengthMask = termLength - 1;
        flowControl.initialize(initialTermId, termLength);
        long time = nanoClock.nanoTime();
        this.timeOfLastSendOrHeartbeat = time - Configuration.PUBLICATION_HEARTBEAT_TIMEOUT_NS - 1L;
        this.timeOfLastSetup = time - Configuration.PUBLICATION_SETUP_TIMEOUT_NS - 1L;
        this.positionBitsToShift = Integer.numberOfTrailingZeros(termLength);
        this.termWindowLength = Configuration.publicationTermWindowLength(termLength);
    }

    public void close() {
        this.publisherLimit.close();
        this.senderPosition.close();
        this.senderLimit.close();
        for (ReadablePosition position : this.spyPositions) {
            position.close();
        }
        this.rawLog.close();
    }

    public int mtuLength() {
        return this.mtuLength;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public int send(long now) {
        int bytesSent;
        long senderPosition = this.senderPosition.get();
        int activeTermId = LogBufferDescriptor.computeTermIdFromPosition((long)senderPosition, (int)this.positionBitsToShift, (int)this.initialTermId);
        int termOffset = (int)senderPosition & this.termLengthMask;
        if (this.shouldSendSetupFrame) {
            this.setupMessageCheck(now, activeTermId, termOffset);
        }
        if (0 == (bytesSent = this.sendData(now, senderPosition, termOffset))) {
            bytesSent = this.heartbeatMessageCheck(now, activeTermId, termOffset);
            this.senderLimit.setOrdered(this.flowControl.onIdle(now, this.senderLimit.get()));
        }
        this.retransmitHandler.processTimeouts(now, this);
        return bytesSent;
    }

    public SendChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    @Override
    public void resend(int termId, int termOffset, int length) {
        long senderPosition = this.senderPosition.get();
        long resendPosition = LogBufferDescriptor.computePosition((int)termId, (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
        if (resendPosition < senderPosition && resendPosition >= senderPosition - (long)this.rawLog.termLength()) {
            long scanOutcome;
            int available;
            int activeIndex = LogBufferDescriptor.indexByPosition((long)resendPosition, (int)this.positionBitsToShift);
            UnsafeBuffer termBuffer = this.termBuffers[activeIndex];
            ByteBuffer sendBuffer = this.sendBuffers[activeIndex];
            int remainingBytes = length;
            int bytesSent = 0;
            int offset = termOffset;
            while ((available = TermScanner.available((long)(scanOutcome = TermScanner.scanForAvailability((UnsafeBuffer)termBuffer, (int)(offset += bytesSent), (int)this.mtuLength)))) > 0) {
                sendBuffer.limit(offset + available).position(offset);
                if (available != this.channelEndpoint.send(sendBuffer)) {
                    this.shortSends.increment();
                    break;
                }
                bytesSent = available + TermScanner.padding((long)scanOutcome);
                if ((remainingBytes -= bytesSent) > 0) continue;
            }
            this.retransmitsSent.orderedIncrement();
        }
    }

    public void triggerSendSetupFrame() {
        this.shouldSendSetupFrame = true;
    }

    @Override
    public void addSubscriber(ReadablePosition spyPosition) {
        this.spyPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.spyPositions, (Object)spyPosition);
    }

    @Override
    public void removeSubscriber(ReadablePosition spyPosition) {
        this.spyPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.spyPositions, (Object)spyPosition);
        spyPosition.close();
    }

    public void onNak(int termId, int termOffset, int length) {
        this.retransmitHandler.onNak(termId, termOffset, length, this.termLengthMask + 1, this);
    }

    public void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress srcAddress) {
        LogBufferDescriptor.timeOfLastStatusMessage((UnsafeBuffer)this.rawLog.metaData(), (long)this.epochClock.time());
        if (!this.isConnected) {
            this.isConnected = true;
        }
        this.senderLimit.setOrdered(this.flowControl.onStatusMessage(msg, srcAddress, this.senderLimit.get(), this.initialTermId, this.positionBitsToShift, this.nanoClock.nanoTime()));
    }

    public void onRttMeasurement(RttMeasurementFlyweight msg, InetSocketAddress srcAddress) {
        if (128 == (msg.flags() & 0x80)) {
            this.rttMeasurementHeader.receiverId(msg.receiverId()).echoTimestamp(msg.echoTimestamp()).receptionDelta(0L).sessionId(this.sessionId).streamId(this.streamId).flags((short)0);
            int bytesSent = this.channelEndpoint.send(this.rttMeasurementBuffer);
            if (40 != bytesSent) {
                this.shortSends.increment();
            }
        }
    }

    RawLog rawLog() {
        return this.rawLog;
    }

    int publisherLimitId() {
        return this.publisherLimit.id();
    }

    int updatePublishersLimit() {
        int workCount = 0;
        if (this.isConnected) {
            long proposedPublisherLimit;
            long minConsumerPosition = this.senderPosition.getVolatile();
            if (this.spyPositions.length > 0) {
                for (ReadablePosition spyPosition : this.spyPositions) {
                    minConsumerPosition = Math.min(minConsumerPosition, spyPosition.getVolatile());
                }
            }
            if (this.publisherLimit.proposeMaxOrdered(proposedPublisherLimit = minConsumerPosition + (long)this.termWindowLength)) {
                this.cleanBuffer(proposedPublisherLimit);
                workCount = 1;
            }
        } else {
            this.publisherLimit.setOrdered(this.senderPosition.getVolatile());
        }
        return workCount;
    }

    boolean hasSpies() {
        return this.spyPositions.length > 0;
    }

    long spyJoiningPosition() {
        long maxSpyPosition = this.producerPosition();
        for (ReadablePosition spyPosition : this.spyPositions) {
            maxSpyPosition = Math.max(maxSpyPosition, spyPosition.getVolatile());
        }
        return maxSpyPosition;
    }

    private int sendData(long now, long senderPosition, int termOffset) {
        int bytesSent = 0;
        int availableWindow = (int)(this.senderLimit.get() - senderPosition);
        if (availableWindow > 0) {
            int scanLimit = Math.min(availableWindow, this.mtuLength);
            int activeIndex = LogBufferDescriptor.indexByPosition((long)senderPosition, (int)this.positionBitsToShift);
            long scanOutcome = TermScanner.scanForAvailability((UnsafeBuffer)this.termBuffers[activeIndex], (int)termOffset, (int)scanLimit);
            int available = TermScanner.available((long)scanOutcome);
            if (available > 0) {
                ByteBuffer sendBuffer = this.sendBuffers[activeIndex];
                sendBuffer.limit(termOffset + available).position(termOffset);
                if (available == this.channelEndpoint.send(sendBuffer)) {
                    this.timeOfLastSendOrHeartbeat = now;
                    this.trackSenderLimits = true;
                    bytesSent = available;
                    this.senderPosition.setOrdered(senderPosition + (long)bytesSent + (long)TermScanner.padding((long)scanOutcome));
                } else {
                    this.shortSends.increment();
                }
            }
        } else if (this.trackSenderLimits) {
            this.trackSenderLimits = false;
            this.senderFlowControlLimits.orderedIncrement();
        }
        return bytesSent;
    }

    private void setupMessageCheck(long nowNs, int activeTermId, int termOffset) {
        if (nowNs > this.timeOfLastSetup + Configuration.PUBLICATION_SETUP_TIMEOUT_NS) {
            this.setupBuffer.clear();
            this.setupHeader.activeTermId(activeTermId).termOffset(termOffset).sessionId(this.sessionId).streamId(this.streamId).initialTermId(this.initialTermId).termLength(this.termLengthMask + 1).mtuLength(this.mtuLength).ttl(this.channelEndpoint.multicastTtl());
            int bytesSent = this.channelEndpoint.send(this.setupBuffer);
            if (40 != bytesSent) {
                this.shortSends.increment();
            }
            this.timeOfLastSetup = nowNs;
            this.timeOfLastSendOrHeartbeat = nowNs;
            if (this.isConnected) {
                this.shouldSendSetupFrame = false;
            }
        }
    }

    private int heartbeatMessageCheck(long nowNs, int activeTermId, int termOffset) {
        int bytesSent = 0;
        if (nowNs > this.timeOfLastSendOrHeartbeat + Configuration.PUBLICATION_HEARTBEAT_TIMEOUT_NS) {
            this.heartbeatBuffer.clear();
            this.heartbeatDataHeader.sessionId(this.sessionId).streamId(this.streamId).termId(activeTermId).termOffset(termOffset);
            bytesSent = this.channelEndpoint.send(this.heartbeatBuffer);
            if (32 != bytesSent) {
                this.shortSends.increment();
            }
            this.heartbeatsSent.orderedIncrement();
            this.timeOfLastSendOrHeartbeat = nowNs;
        }
        return bytesSent;
    }

    private boolean isUnreferencedAndPotentiallyInactive(long now) {
        boolean result = false;
        if (0 == this.refCount) {
            long senderPosition = this.senderPosition.getVolatile();
            this.timeOfLastActivity = senderPosition == this.lastSenderPosition ? this.timeOfLastActivity : now;
            this.lastSenderPosition = senderPosition;
            result = true;
        } else {
            this.timeOfLastActivity = now;
        }
        return result;
    }

    private void cleanBuffer(long publisherLimit) {
        long cleanPosition = this.cleanPosition;
        long dirtyRange = publisherLimit - cleanPosition;
        int bufferCapacity = this.termLengthMask + 1;
        int reservedRange = bufferCapacity * 2;
        if (dirtyRange > (long)reservedRange) {
            UnsafeBuffer dirtyTerm = this.termBuffers[LogBufferDescriptor.indexByPosition((long)cleanPosition, (int)this.positionBitsToShift)];
            int termOffset = (int)cleanPosition & this.termLengthMask;
            int bytesForCleaning = (int)(dirtyRange - (long)reservedRange);
            int length = Math.min(bytesForCleaning, bufferCapacity - termOffset);
            dirtyTerm.setMemory(termOffset, length, (byte)0);
            this.cleanPosition = cleanPosition + (long)length;
        }
    }

    private void checkForBlockedPublisher(long timeNs) {
        long consumerPosition = this.senderPosition.getVolatile();
        if (consumerPosition == this.lastConsumerPosition) {
            if (this.producerPosition() > consumerPosition && timeNs > this.timeOfLastConsumerPositionChange + this.unblockTimeoutNs && this.unblockAtConsumerPosition()) {
                this.unblockedPublications.orderedIncrement();
            }
        } else {
            this.timeOfLastConsumerPositionChange = timeNs;
            this.lastConsumerPosition = consumerPosition;
        }
    }

    private boolean haveSpiesCaughtUpWithTheSender() {
        long senderPosition = this.senderPosition.getVolatile();
        for (ReadablePosition spyPosition : this.spyPositions) {
            if (spyPosition.getVolatile() >= senderPosition) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        if (this.isUnreferencedAndPotentiallyInactive(timeNs) && timeNs > this.timeOfLastActivity + Configuration.PUBLICATION_LINGER_NS && this.haveSpiesCaughtUpWithTheSender()) {
            this.hasReachedEndOfLife = true;
            conductor.cleanupPublication(this);
        } else {
            if (!this.isExclusive) {
                this.checkForBlockedPublisher(timeNs);
            }
            if (this.isConnected && timeMs > LogBufferDescriptor.timeOfLastStatusMessage((UnsafeBuffer)this.rawLog.metaData()) + Aeron.PUBLICATION_CONNECTION_TIMEOUT_MS) {
                this.isConnected = false;
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.hasReachedEndOfLife;
    }

    public void timeOfLastStateChange(long time) {
    }

    public long timeOfLastStateChange() {
        return this.timeOfLastActivity;
    }

    public void delete() {
    }

    @Override
    public int decRef() {
        int count;
        if (0 == (count = --this.refCount)) {
            this.status = Status.INACTIVE;
            this.channelEndpoint.decRef();
        }
        return count;
    }

    @Override
    public int incRef() {
        return ++this.refCount;
    }

    public Status status() {
        return this.status;
    }

    @Override
    public long producerPosition() {
        long rawTail = LogBufferDescriptor.rawTailVolatile((UnsafeBuffer)this.rawLog.metaData());
        int termOffset = LogBufferDescriptor.termOffset((long)rawTail, (long)this.rawLog.termLength());
        return LogBufferDescriptor.computePosition((int)LogBufferDescriptor.termId((long)rawTail), (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
    }

    @Override
    public long consumerPosition() {
        return this.senderPosition.getVolatile();
    }

    @Override
    public boolean unblockAtConsumerPosition() {
        return LogBufferUnblocker.unblock((UnsafeBuffer[])this.termBuffers, (UnsafeBuffer)this.rawLog.metaData(), (long)this.senderPosition.getVolatile());
    }

    public static enum Status {
        ACTIVE,
        INACTIVE;

    }
}

