/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.status;

import java.nio.charset.StandardCharsets;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public class ChannelEndpointStatus {
    public static final long INITIALIZING = 0L;
    public static final long ERRORED = -1L;
    public static final long ACTIVE = 1L;
    public static final long CLOSING = 2L;
    public static final int CHANNEL_OFFSET = 0;
    public static final int MAX_CHANNEL_LENGTH = 116;

    public static String status(long status) {
        if (0L == status) {
            return "INITIALIZING";
        }
        if (-1L == status) {
            return "ERRORED";
        }
        if (1L == status) {
            return "ACTIVE";
        }
        if (2L == status) {
            return "CLOSING";
        }
        return "unknown id=" + status;
    }

    public static AtomicCounter allocate(String name, int typeId, CountersManager countersManager, String channel) {
        String label = name + ": " + channel;
        return countersManager.newCounter(label, typeId, buffer -> {
            byte[] channelBytes = channel.getBytes(StandardCharsets.UTF_8);
            int length = Math.min(channelBytes.length, 116);
            buffer.putInt(0, length);
            buffer.putBytes(4, channelBytes, 0, length);
        });
    }
}

