/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;

public class FragmentAssembler
implements FragmentHandler {
    private final int initialBufferLength;
    private final FragmentHandler delegate;
    private final Int2ObjectHashMap<BufferBuilder> builderBySessionIdMap = new Int2ObjectHashMap();

    public FragmentAssembler(FragmentHandler delegate) {
        this(delegate, 4096);
    }

    public FragmentAssembler(FragmentHandler delegate, int initialBufferLength) {
        this.initialBufferLength = initialBufferLength;
        this.delegate = delegate;
    }

    public FragmentHandler delegate() {
        return this.delegate;
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        byte flags = header.flags();
        if ((flags & 0xFFFFFFC0) == -64) {
            this.delegate.onFragment(buffer, offset, length, header);
        } else {
            this.handleFragment(buffer, offset, length, header, flags);
        }
    }

    private void handleFragment(DirectBuffer buffer, int offset, int length, Header header, byte flags) {
        if ((flags & 0xFFFFFF80) == -128) {
            BufferBuilder builder = this.getBufferBuilder(header.sessionId());
            builder.reset().append(buffer, offset, length);
        } else {
            BufferBuilder builder = (BufferBuilder)this.builderBySessionIdMap.get(header.sessionId());
            if (null != builder && builder.limit() != 0) {
                builder.append(buffer, offset, length);
                if ((flags & 0x40) == 64) {
                    int msgLength = builder.limit();
                    this.delegate.onFragment((DirectBuffer)builder.buffer(), 0, msgLength, header);
                    builder.reset();
                }
            }
        }
    }

    public boolean freeSessionBuffer(int sessionId) {
        return null != this.builderBySessionIdMap.remove(sessionId);
    }

    public void clear() {
        this.builderBySessionIdMap.clear();
    }

    private BufferBuilder getBufferBuilder(int sessionId) {
        BufferBuilder bufferBuilder = (BufferBuilder)this.builderBySessionIdMap.get(sessionId);
        if (null == bufferBuilder) {
            bufferBuilder = new BufferBuilder(this.initialBufferLength);
            this.builderBySessionIdMap.put(sessionId, (Object)bufferBuilder);
        }
        return bufferBuilder;
    }
}

