/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.AvailableImageHandler;
import io.aeron.ClientConductor;
import io.aeron.Image;
import io.aeron.SubscriptionFields;
import io.aeron.UnavailableImageHandler;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.RawBlockHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.collections.ArrayUtil;

public class Subscription
extends SubscriptionFields
implements AutoCloseable {
    protected long p16;
    protected long p17;
    protected long p18;
    protected long p19;
    protected long p20;
    protected long p21;
    protected long p22;
    protected long p23;
    protected long p24;
    protected long p25;
    protected long p26;
    protected long p27;
    protected long p28;
    protected long p29;
    protected long p30;

    Subscription(ClientConductor conductor, String channel, int streamId, long registrationId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        super(registrationId, streamId, conductor, channel, availableImageHandler, unavailableImageHandler);
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public AvailableImageHandler availableImageHandler() {
        return this.availableImageHandler;
    }

    public UnavailableImageHandler unavailableImageHandler() {
        return this.unavailableImageHandler;
    }

    public int poll(FragmentHandler fragmentHandler, int fragmentLimit) {
        int i;
        int startingIndex;
        Image[] images = this.images;
        int length = images.length;
        int fragmentsRead = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length && fragmentsRead < fragmentLimit; fragmentsRead += images[i].poll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        for (i = 0; i < startingIndex && fragmentsRead < fragmentLimit; fragmentsRead += images[i].poll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        return fragmentsRead;
    }

    public int controlledPoll(ControlledFragmentHandler fragmentHandler, int fragmentLimit) {
        int i;
        int startingIndex;
        Image[] images = this.images;
        int length = images.length;
        int fragmentsRead = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length && fragmentsRead < fragmentLimit; fragmentsRead += images[i].controlledPoll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        for (i = 0; i < startingIndex && fragmentsRead < fragmentLimit; fragmentsRead += images[i].controlledPoll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        return fragmentsRead;
    }

    public long blockPoll(BlockHandler blockHandler, int blockLengthLimit) {
        long bytesConsumed = 0L;
        for (Image image : this.images) {
            bytesConsumed += (long)image.blockPoll(blockHandler, blockLengthLimit);
        }
        return bytesConsumed;
    }

    public long rawPoll(RawBlockHandler rawBlockHandler, int blockLengthLimit) {
        long bytesConsumed = 0L;
        for (Image image : this.images) {
            bytesConsumed += (long)image.rawPoll(rawBlockHandler, blockLengthLimit);
        }
        return bytesConsumed;
    }

    public boolean hasNoImages() {
        return this.images.length == 0;
    }

    public int imageCount() {
        return this.images.length;
    }

    public Image imageBySessionId(int sessionId) {
        Image result = null;
        for (Image image : this.images) {
            if (sessionId != image.sessionId()) continue;
            result = image;
            break;
        }
        return result;
    }

    public List<Image> images() {
        return Collections.unmodifiableList(Arrays.asList(this.images));
    }

    public void forEachImage(Consumer<Image> imageConsumer) {
        for (Image image : this.images) {
            imageConsumer.accept(image);
        }
    }

    public Image getImage(int index) {
        return this.images[index];
    }

    @Override
    public void close() {
        this.clientConductor.clientLock().lock();
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.closeImages();
                this.clientConductor.releaseSubscription(this);
            }
        }
        finally {
            this.clientConductor.clientLock().unlock();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    void forceClose() {
        this.isClosed = true;
        this.closeImages();
        this.clientConductor.asyncReleaseSubscription(this);
    }

    void addImage(Image image) {
        if (this.isClosed) {
            this.clientConductor.lingerResource(image.managedResource());
        } else {
            this.images = (Image[])ArrayUtil.add((Object[])this.images, (Object)image);
        }
    }

    Image removeImage(long correlationId) {
        Object[] oldArray = this.images;
        Image removedImage = null;
        for (Image image : oldArray) {
            if (image.correlationId() != correlationId) continue;
            removedImage = image;
            break;
        }
        if (null != removedImage) {
            this.images = (Image[])ArrayUtil.remove((Object[])oldArray, removedImage);
            this.clientConductor.lingerResource(removedImage.managedResource());
        }
        return removedImage;
    }

    boolean hasImage(long correlationId) {
        boolean hasImage = false;
        for (Image image : this.images) {
            if (correlationId != image.correlationId()) continue;
            hasImage = true;
            break;
        }
        return hasImage;
    }

    private void closeImages() {
        for (Image image : this.images) {
            this.clientConductor.lingerResource(image.managedResource());
            try {
                if (null == this.unavailableImageHandler) continue;
                this.unavailableImageHandler.onUnavailableImage(image);
            }
            catch (Throwable ex) {
                this.clientConductor.handleError(ex);
            }
        }
        this.images = EMPTY_ARRAY;
    }
}

