/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;

public class Header {
    private final int positionBitsToShift;
    private final int initialTermId;
    private int offset = 0;
    private DirectBuffer buffer;

    public Header(int initialTermId, int positionBitsToShift) {
        this.initialTermId = initialTermId;
        this.positionBitsToShift = positionBitsToShift;
    }

    public final long position() {
        int resultingOffset = BitUtil.align((int)(this.termOffset() + this.frameLength()), (int)32);
        return LogBufferDescriptor.computePosition(this.termId(), resultingOffset, this.positionBitsToShift, this.initialTermId);
    }

    public final int initialTermId() {
        return this.initialTermId;
    }

    public final void offset(int offset) {
        this.offset = offset;
    }

    public final int offset() {
        return this.offset;
    }

    public final DirectBuffer buffer() {
        return this.buffer;
    }

    public final void buffer(DirectBuffer buffer) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
    }

    public int frameLength() {
        return this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
    }

    public final int sessionId() {
        return this.buffer.getInt(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public final int streamId() {
        return this.buffer.getInt(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public final int termId() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public int termOffset() {
        return this.offset;
    }

    public final int type() {
        return this.buffer.getShort(this.offset + 6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public byte flags() {
        return this.buffer.getByte(this.offset + 5);
    }

    public long reservedValue() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }
}

