/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class StatusMessageFlyweight
extends HeaderFlyweight {
    public static final int HEADER_LENGTH = 36;
    public static final short SEND_SETUP_FLAG = 128;
    private static final int SESSION_ID_FIELD_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 12;
    private static final int CONSUMPTION_TERM_ID_FIELD_OFFSET = 16;
    private static final int CONSUMPTION_TERM_OFFSET_FIELD_OFFSET = 20;
    private static final int RECEIVER_WINDOW_FIELD_OFFSET = 24;
    private static final int RECEIVER_ID_FIELD_OFFSET = 28;
    private static final int APP_SPECIFIC_FEEDBACK_FIELD_OFFSET = 36;

    public StatusMessageFlyweight() {
    }

    public StatusMessageFlyweight(ByteBuffer buffer) {
        super(buffer);
    }

    public StatusMessageFlyweight(UnsafeBuffer buffer) {
        super(buffer);
    }

    public int sessionId() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight sessionId(int sessionId) {
        this.putInt(8, sessionId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight streamId(int streamId) {
        this.putInt(12, streamId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int consumptionTermOffset() {
        return this.getInt(20, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight consumptionTermOffset(int termOffset) {
        this.putInt(20, termOffset, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int consumptionTermId() {
        return this.getInt(16, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight consumptionTermId(int termId) {
        this.putInt(16, termId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int receiverWindowLength() {
        return this.getInt(24, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight receiverWindowLength(int receiverWindowLength) {
        this.putInt(24, receiverWindowLength, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long receiverId() {
        return this.getLong(28, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight receiverId(long id) {
        this.putLong(28, id, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int applicationSpecificFeedback(byte[] destination) {
        int frameLength = this.frameLength();
        int result = 0;
        if (frameLength > 36) {
            if (frameLength > this.capacity()) {
                throw new IllegalStateException(String.format("SM application specific feedback (%d) is truncated (%d)", frameLength - 36, this.capacity() - 36));
            }
            int copyLength = Math.min(destination.length, frameLength - 36);
            this.getBytes(36, destination, 0, copyLength);
            result = copyLength;
        }
        return result;
    }

    public StatusMessageFlyweight applicationSpecificFeedback(byte[] source, int offset, int length) {
        this.frameLength(36 + length);
        this.putBytes(36, source, offset, length);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String formattedFlags = String.format("%1$8s", Integer.toBinaryString(this.flags())).replace(' ', '0');
        sb.append("STATUS Message{").append("frame_length=").append(this.frameLength()).append(" version=").append(this.version()).append(" flags=").append(formattedFlags).append(" type=").append(this.headerType()).append(" session_id=").append(this.sessionId()).append(" stream_id=").append(this.streamId()).append(" consumption_term_id=").append(this.consumptionTermId()).append(" consumption_term_offset=").append(this.consumptionTermOffset()).append(" receiver_window_length=").append(this.receiverWindowLength()).append("}");
        return sb.toString();
    }
}

