/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.ringbuffer;

import org.agrona.BitUtil;

public class RingBufferDescriptor {
    public static final int TAIL_POSITION_OFFSET;
    public static final int HEAD_CACHE_POSITION_OFFSET;
    public static final int HEAD_POSITION_OFFSET;
    public static final int CORRELATION_COUNTER_OFFSET;
    public static final int CONSUMER_HEARTBEAT_OFFSET;
    public static final int TRAILER_LENGTH;

    public static void checkCapacity(int capacity) {
        if (!BitUtil.isPowerOfTwo(capacity - TRAILER_LENGTH)) {
            String msg = "Capacity must be a positive power of 2 + TRAILER_LENGTH: capacity=" + capacity;
            throw new IllegalStateException(msg);
        }
    }

    static {
        int offset = 0;
        TAIL_POSITION_OFFSET = offset += 128;
        HEAD_CACHE_POSITION_OFFSET = offset += 128;
        HEAD_POSITION_OFFSET = offset += 128;
        CORRELATION_COUNTER_OFFSET = offset += 128;
        CONSUMER_HEARTBEAT_OFFSET = offset += 128;
        TRAILER_LENGTH = offset += 128;
    }
}

