/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication.viewas;

import com.xebialabs.deployit.security.authentication.viewas.ViewAsAuthenticationFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.CommunicationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class UserDetailsViewAsAuthenticationFinder
implements ViewAsAuthenticationFinder {
    @Autowired(required=false)
    private UserDetailsService userDetailsService;
    private static final Logger logger = LoggerFactory.getLogger(UserDetailsViewAsAuthenticationFinder.class);

    public UserDetailsViewAsAuthenticationFinder() {
    }

    public UserDetailsViewAsAuthenticationFinder(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    @Override
    public Authentication search(String username) {
        try {
            if (this.userDetailsService != null) {
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
                return new UsernamePasswordAuthenticationToken((Object)username, null, userDetails.getAuthorities());
            }
        }
        catch (UsernameNotFoundException e) {
            logger.debug("Username not found: " + username);
        }
        catch (CommunicationException e) {
            logger.debug(e.toString());
        }
        catch (Exception e) {
            logger.debug(e.toString());
        }
        return null;
    }
}

