/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.io.Dns;
import akka.io.Dns$Resolved$;
import akka.io.SimpleDnsCache;
import akka.util.Helpers$;
import akka.util.Helpers$Requiring$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import sun.net.InetAddressCachePolicy;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u000f\t1\u0012J\\3u\u0003\u0012$'/Z:t\t:\u001c(+Z:pYZ,'O\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0002\u000b\u0005!\u0011m[6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006C\u000e$xN]\u0005\u0003'A\u0011Q!Q2u_JD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0003/ai\u0011AA\u0005\u00033\t\u0011abU5na2,GI\\:DC\u000eDW\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0019\u0019wN\u001c4jOB\u0011QdI\u0007\u0002=)\u00111d\b\u0006\u0003A\u0005\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002E\u0005\u00191m\\7\n\u0005\u0011r\"AB\"p]\u001aLw\rC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0004Q%R\u0003CA\f\u0001\u0011\u0015)R\u00051\u0001\u0017\u0011\u0015YR\u00051\u0001\u001d\u0011\u0015a\u0003\u0001\"\u0003.\u0003\u00199W\r\u001e+uYR\u0019a&\r \u0011\u0005%y\u0013B\u0001\u0019\u000b\u0005\u0011auN\\4\t\u000bIZ\u0003\u0019A\u001a\u0002\tA\fG\u000f\u001b\t\u0003imr!!N\u001d\u0011\u0005YRQ\"A\u001c\u000b\u0005a2\u0011A\u0002\u001fs_>$h(\u0003\u0002;\u0015\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQ$\u0002C\u0003@W\u0001\u0007\u0001)\u0001\u0005q_NLG/\u001b<f!\tI\u0011)\u0003\u0002C\u0015\t9!i\\8mK\u0006t\u0007b\u0002#\u0001\u0005\u0004%\t!R\u0001\fa>\u001c\u0018\u000e^5wKR#H.F\u0001/\u0011\u00199\u0005\u0001)A\u0005]\u0005a\u0001o\\:ji&4X\r\u0016;mA!9\u0011\n\u0001b\u0001\n\u0003)\u0015a\u00038fO\u0006$\u0018N^3Ui2Daa\u0013\u0001!\u0002\u0013q\u0013\u0001\u00048fO\u0006$\u0018N^3Ui2\u0004\u0003\"B'\u0001\t\u0003r\u0015a\u0002:fG\u0016Lg/Z\u000b\u0002\u001fB!\u0011\u0002\u0015*V\u0013\t\t&BA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o!\tI1+\u0003\u0002U\u0015\t\u0019\u0011I\\=\u0011\u0005%1\u0016BA,\u000b\u0005\u0011)f.\u001b;")
public class InetAddressDnsResolver
implements Actor {
    public final SimpleDnsCache akka$io$InetAddressDnsResolver$$cache;
    private final Config config;
    private final long positiveTtl;
    private final long negativeTtl;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    private long getTtl(String path, boolean positive) {
        long l;
        String string = this.config.getString(path);
        if ("default".equals(string)) {
            long l2;
            int n = positive ? InetAddressCachePolicy.get() : InetAddressCachePolicy.getNegative();
            switch (n) {
                case 0: {
                    l2 = 0L;
                    break;
                }
                default: {
                    if (n > 0) {
                        l2 = TimeUnit.SECONDS.toMillis(n);
                        break;
                    }
                    l2 = Long.MAX_VALUE;
                    break;
                }
            }
            l = l2;
        } else {
            l = "forever".equals(string) ? Long.MAX_VALUE : ("never".equals(string) ? 0L : BoxesRunTime.unboxToLong((Object)Helpers$Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring(BoxesRunTime.boxToLong((long)this.config.getDuration(path, TimeUnit.MILLISECONDS))), (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0L, (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.io.dns.", " must be 'default', 'forever', 'never' or positive duration"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})))));
        }
        return l;
    }

    public long positiveTtl() {
        return this.positiveTtl;
    }

    public long negativeTtl() {
        return this.negativeTtl;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InetAddressDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Dns.Resolve) {
                    Dns.Resolved resolved;
                    Dns.Resolve resolve = (Dns.Resolve)A1;
                    String name = resolve.name();
                    Option<Dns.Resolved> option = this.$outer.akka$io$InetAddressDnsResolver$$cache.cached(name);
                    if (option instanceof Some) {
                        Dns.Resolved a;
                        Some some = (Some)option;
                        resolved = a = (Dns.Resolved)some.value();
                    } else if (None$.MODULE$.equals(option)) {
                        Dns.Resolved resolved2;
                        try {
                            Dns.Resolved answer = Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)Predef$.MODULE$.wrapRefArray((Object[])InetAddress.getAllByName(name)));
                            if (this.$outer.positiveTtl() != 0L) {
                                this.$outer.akka$io$InetAddressDnsResolver$$cache.put(answer, this.$outer.positiveTtl());
                            }
                            resolved2 = answer;
                        }
                        catch (UnknownHostException e) {
                            Dns.Resolved answer = new Dns.Resolved(name, (scala.collection.immutable.Seq<Inet4Address>)((scala.collection.immutable.Seq)Seq$.MODULE$.empty()), (scala.collection.immutable.Seq<Inet6Address>)((scala.collection.immutable.Seq)Seq$.MODULE$.empty()));
                            if (this.$outer.negativeTtl() != 0L) {
                                this.$outer.akka$io$InetAddressDnsResolver$$cache.put(answer, this.$outer.negativeTtl());
                            }
                            resolved2 = answer;
                        }
                        resolved = resolved2;
                    } else {
                        throw new MatchError(option);
                    }
                    Dns.Resolved answer = resolved;
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(answer, this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof Dns.Resolve;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public InetAddressDnsResolver(SimpleDnsCache cache, Config config) {
        this.akka$io$InetAddressDnsResolver$$cache = cache;
        this.config = config;
        Actor.$init$(this);
        this.positiveTtl = this.getTtl("positive-ttl", true);
        this.negativeTtl = this.getTtl("negative-ttl", false);
    }
}

