/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.security.JcrPermissions;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlplatform.security.JcrLocalRoleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;

public class JcrRoleService
extends JcrLocalRoleService
implements RoleService {
    private static final AtomicInteger groupNumber = new AtomicInteger(-1);
    private JcrTemplate jcrTemplate;
    private static final Logger logger = LoggerFactory.getLogger(JcrRoleService.class);

    @Autowired
    public JcrRoleService(JcrTemplate jcrTemplate) {
        super(jcrTemplate);
        this.jcrTemplate = jcrTemplate;
    }

    @Override
    public List<Role> getRoles() {
        return (List)this.jcrTemplate.execute(this::readRoles);
    }

    public List<Role> readRoleAssignments() {
        return (List)this.jcrTemplate.execute(this::readRoleAssignments);
    }

    public void writeRoleAssignments(List<Role> roles) {
        this.jcrTemplate.execute(session -> {
            this.writeRoles(session, roles);
            this.writeRoleAssignments(session, roles);
            session.save();
            return null;
        });
    }

    public Role getRoleForRoleName(String roleName) {
        List<Role> roles = this.getRoles();
        for (Role role : roles) {
            if (!role.getName().equals(roleName)) continue;
            return role;
        }
        throw new NotFoundException("Could not find the role [%s]", new Object[]{roleName});
    }

    public List<Role> getRolesFor(Authentication auth) {
        Collection principals = Permissions.authenticationToPrincipals((Authentication)auth);
        return this.getRolesFor(principals);
    }

    public List<Role> getRolesFor(String principal) {
        return this.getRolesFor(Collections.singletonList(principal));
    }

    private List<Role> readRoles(Session session) throws RepositoryException {
        Node node = session.getNode("/$configuration/roles");
        ArrayList<Role> roles = new ArrayList<Role>();
        JcrUtils.forEachNonJcrProperty((Node)node, input -> roles.add(new Role(input.getName(), input.getString())));
        return roles;
    }

    private List<Role> readRoleAssignments(Session session) throws RepositoryException {
        Node node = session.getNode("/$configuration/roleAssignments");
        List<Role> roles = this.getRoles();
        Map<String, Role> lookup = JcrPermissions.buildLookupById(roles);
        JcrUtils.forEachNonJcrProperty((Node)node, input -> {
            String principal = input.getName();
            principal = JcrUtils.unescapeIllegalJcrChars((String)principal);
            for (String role : JcrPermissions.splitIds(input.getString())) {
                ((Role)lookup.get(role)).getPrincipals().add(principal);
            }
        });
        return roles;
    }

    private void writeRoles(Session session, List<Role> roles) throws RepositoryException {
        Node node = session.getNode("/$configuration/roles");
        if (groupNumber.get() == -1) {
            groupNumber.compareAndSet(-1, this.readMaxRole(node) + 1);
        }
        JcrUtils.clearProperties((Node)node);
        for (Role role : roles) {
            if (role.getId() == null || role.getId().equals("-1")) {
                role.setId(String.valueOf(groupNumber.getAndIncrement()));
            }
            node.setProperty(role.getId(), role.getName());
        }
    }

    private int readMaxRole(Node node) throws RepositoryException {
        int[] i = new int[]{-1};
        JcrUtils.forEachNonJcrProperty((Node)node, input -> {
            int j = Integer.valueOf(input.getName());
            if (j > i[0]) {
                i[0] = j;
            }
        });
        return i[0];
    }

    private List<Role> getRolesFor(Collection<String> principals) {
        return (List)this.jcrTemplate.execute(session -> this.principalsToRoles(session, principals));
    }

    private List<Role> principalsToRoles(Session session, Collection<String> principals) throws RepositoryException {
        Node node = session.getNode("/$configuration/roleAssignments");
        Map<String, Role> lookup = JcrPermissions.buildLookupById(this.getRoles());
        ArrayList<Role> roles = new ArrayList<Role>();
        for (String principal : principals) {
            if (!node.hasProperty(principal = JcrUtils.escapeIllegalJcrChars((String)principal))) continue;
            Property property = node.getProperty(principal);
            roles.addAll(JcrPermissions.splitIds(property.getString()).stream().map(lookup::get).collect(Collectors.toList()));
        }
        logger.trace("Found roles {} for principals {}", roles, principals);
        return roles;
    }

    private void writeRoleAssignments(Session session, List<Role> map) throws RepositoryException {
        Node node = session.getNode("/$configuration/roleAssignments");
        JcrUtils.clearProperties((Node)node);
        Map<String, List<Role>> principalRole = this.buildMap(map);
        for (String principal : principalRole.keySet()) {
            node.setProperty(JcrUtils.escapeIllegalJcrChars((String)principal), JcrPermissions.joinIds(principalRole.get(principal).stream().map(Role::getId)));
        }
    }

    private Map<String, List<Role>> buildMap(List<Role> map) {
        HashMap<String, List<Role>> principalToRoles = new HashMap<String, List<Role>>();
        for (Role role : map) {
            for (String principal : role.getPrincipals()) {
                principalToRoles.computeIfAbsent(principal, p -> new ArrayList()).add(role);
            }
        }
        return principalToRoles;
    }
}

